/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ContainerTopResponse;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopContainerCmd
extends AbstrDockerCmd<TopContainerCmd, ContainerTopResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopContainerCmd.class);
    private String containerId;
    private String psArgs;

    public TopContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public TopContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public TopContainerCmd withPsArgs(String psArgs) {
        Preconditions.checkNotNull((Object)psArgs, (Object)"psArgs was not specified");
        this.psArgs = psArgs;
        return this;
    }

    @Override
    protected ContainerTopResponse impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/top", this.containerId));
        if (!StringUtils.isEmpty((String)this.psArgs)) {
            webResource = webResource.queryParam("ps_args", this.psArgs);
        }
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (ContainerTopResponse)webResource.accept(new String[]{"application/json"}).get(ContainerTopResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

