/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitContainerCmd
extends AbstrDockerCmd<WaitContainerCmd, Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitContainerCmd.class);
    private String containerId;

    public WaitContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public WaitContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    protected Integer impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/wait", this.containerId));
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            ObjectNode ObjectNode2 = (ObjectNode)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ObjectNode.class);
            return ObjectNode2.get("StatusCode").asInt();
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        catch (Exception e) {
            throw new DockerException(e);
        }
    }
}

