/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.client.model.Volume;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Bind {
    private String path;
    private Volume volume;
    private boolean readOnly = false;

    public Bind(String path, Volume volume) {
        this(path, volume, false);
    }

    public Bind(String path, Volume volume, boolean readOnly) {
        this.path = path;
        this.volume = volume;
        this.readOnly = readOnly;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], Volume.parse(parts[1]));
                }
                case 3: {
                    if ("rw".equals(parts[3].toLowerCase())) {
                        return new Bind(parts[0], Volume.parse(parts[1]), true);
                    }
                    throw new RuntimeException("Error parsing Bind '" + serialized + "'");
                }
            }
            throw new RuntimeException("Error parsing Bind '" + serialized + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing Bind '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bind) {
            Bind other = (Bind)obj;
            return new EqualsBuilder().append((Object)this.path, (Object)other.getPath()).append((Object)this.volume, (Object)other.getVolume()).append(this.readOnly, other.isReadOnly()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).append((Object)this.volume).append(this.readOnly).toHashCode();
    }

    public static class Deserializer
    extends JsonDeserializer<Bind> {
        public Bind deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (!node.equals((Object)NullNode.getInstance())) {
                Map.Entry field = (Map.Entry)node.fields().next();
                return Bind.parse((String)field.getKey());
            }
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Bind> {
        public void serialize(Bind bind, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
        }
    }
}

