/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.client.model.ExposedPort;
import com.github.dockerjava.client.model.ExposedPorts;
import java.util.Arrays;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfig {
    @JsonProperty(value="Hostname")
    private String hostName = "";
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="User")
    private String user = "";
    @JsonProperty(value="Tty")
    private boolean tty = false;
    @JsonProperty(value="OpenStdin")
    private boolean stdinOpen = false;
    @JsonProperty(value="StdinOnce")
    private boolean stdInOnce = false;
    @JsonProperty(value="Memory")
    private long memoryLimit = 0L;
    @JsonProperty(value="MemorySwap")
    private long memorySwap = 0L;
    @JsonProperty(value="CpuShares")
    private int cpuShares = 0;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin = false;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout = false;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr = false;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Map<String, ?> volumes;
    @JsonProperty(value="VolumesFrom")
    private String volumesFrom = "";
    @JsonProperty(value="Entrypoint")
    private String[] entrypoint = new String[0];
    @JsonProperty(value="NetworkDisabled")
    private boolean networkDisabled = false;
    @JsonProperty(value="Privileged")
    private boolean privileged = false;
    @JsonProperty(value="WorkingDir")
    private String workingDir = "";
    @JsonProperty(value="Domainname")
    private String domainName = "";
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts;
    @JsonProperty(value="OnBuild")
    private int[] onBuild;

    @JsonIgnore
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    @JsonIgnore
    public void setExposedPorts(ExposedPort[] exposedPorts) {
        this.exposedPorts = new ExposedPorts(exposedPorts);
    }

    public boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public ContainerConfig setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public ContainerConfig setPrivileged(boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public ContainerConfig setNetworkDisabled(boolean networkDisabled) {
        this.networkDisabled = networkDisabled;
        return this;
    }

    public ContainerConfig setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    public ContainerConfig setPortSpecs(String[] portSpecs) {
        this.portSpecs = portSpecs;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ContainerConfig setUser(String user) {
        this.user = user;
        return this;
    }

    public boolean isTty() {
        return this.tty;
    }

    public ContainerConfig setTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    public boolean isStdinOpen() {
        return this.stdinOpen;
    }

    public ContainerConfig setStdinOpen(boolean stdinOpen) {
        this.stdinOpen = stdinOpen;
        return this;
    }

    public boolean isStdInOnce() {
        return this.stdInOnce;
    }

    public ContainerConfig setStdInOnce(boolean stdInOnce) {
        this.stdInOnce = stdInOnce;
        return this;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public ContainerConfig setMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public long getMemorySwap() {
        return this.memorySwap;
    }

    public ContainerConfig setMemorySwap(long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    public int getCpuShares() {
        return this.cpuShares;
    }

    public ContainerConfig setCpuShares(int cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    public boolean isAttachStdin() {
        return this.attachStdin;
    }

    public ContainerConfig setAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    public boolean isAttachStdout() {
        return this.attachStdout;
    }

    public ContainerConfig setAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    public boolean isAttachStderr() {
        return this.attachStderr;
    }

    public ContainerConfig setAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    public String[] getEnv() {
        return this.env;
    }

    public ContainerConfig setEnv(String[] env) {
        this.env = env;
        return this;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public ContainerConfig setCmd(String[] cmd) {
        this.cmd = cmd;
        return this;
    }

    public String[] getDns() {
        return this.dns;
    }

    public ContainerConfig setDns(String[] dns) {
        this.dns = dns;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public ContainerConfig setImage(String image) {
        this.image = image;
        return this;
    }

    public Map<String, ?> getVolumes() {
        return this.volumes;
    }

    public ContainerConfig setVolumes(Map<String, ?> volumes) {
        this.volumes = volumes;
        return this;
    }

    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    public ContainerConfig setVolumesFrom(String volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public String[] getEntrypoint() {
        return this.entrypoint;
    }

    public ContainerConfig setEntrypoint(String[] entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public void setOnBuild(int[] onBuild) {
        this.onBuild = onBuild;
    }

    public int[] getOnBuild() {
        return this.onBuild;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String toString() {
        return "ContainerConfig{hostName='" + this.hostName + '\'' + ", portSpecs=" + Arrays.toString(this.portSpecs) + ", user='" + this.user + '\'' + ", tty=" + this.tty + ", stdinOpen=" + this.stdinOpen + ", stdInOnce=" + this.stdInOnce + ", memoryLimit=" + this.memoryLimit + ", memorySwap=" + this.memorySwap + ", cpuShares=" + this.cpuShares + ", attachStdin=" + this.attachStdin + ", attachStdout=" + this.attachStdout + ", attachStderr=" + this.attachStderr + ", env=" + Arrays.toString(this.env) + ", cmd=" + Arrays.toString(this.cmd) + ", dns=" + Arrays.toString(this.dns) + ", image='" + this.image + '\'' + ", volumes=" + this.volumes + ", volumesFrom='" + this.volumesFrom + '\'' + ", entrypoint=" + Arrays.toString(this.entrypoint) + ", networkDisabled=" + this.networkDisabled + ", privileged=" + this.privileged + ", workingDir='" + this.workingDir + '\'' + ", domainName='" + this.domainName + '\'' + ", onBuild='" + Arrays.toString(this.onBuild) + '\'' + '}';
    }
}

