/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.client.model.ContainerConfig;
import com.github.dockerjava.client.model.LxcConf;
import com.github.dockerjava.client.model.Ports;
import com.github.dockerjava.client.model.Volume;
import com.github.dockerjava.client.model.Volumes;
import java.util.Arrays;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerInspectResponse {
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="Created")
    private String created;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="Args")
    private String[] args;
    @JsonProperty(value="Config")
    public ContainerConfig config;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Image")
    private String imageId;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="SysInitPath")
    private String sysInitPath;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="Volumes")
    private Volumes volumes;
    @JsonProperty(value="VolumesRW")
    private Volumes volumesRW;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="MountLabel")
    private String mountLabel;

    public String getId() {
        return this.id;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public ContainerState getState() {
        return this.state;
    }

    public String getImageId() {
        return this.imageId;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getSysInitPath() {
        return this.sysInitPath;
    }

    public String getResolvConfPath() {
        return this.resolvConfPath;
    }

    @JsonIgnore
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    @JsonIgnore
    public Volume[] getVolumesRW() {
        return this.volumesRW.getVolumes();
    }

    public String getHostnamePath() {
        return this.hostnamePath;
    }

    public String getHostsPath() {
        return this.hostsPath;
    }

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public String getExecDriver() {
        return this.execDriver;
    }

    public String getMountLabel() {
        return this.mountLabel;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class HostConfig {
        @JsonProperty(value="Binds")
        private String[] binds;
        @JsonProperty(value="LxcConf")
        private LxcConf[] lxcConf;
        @JsonProperty(value="PortBindings")
        private Ports portBindings;
        @JsonProperty(value="PublishAllPorts")
        private boolean publishAllPorts;
        @JsonProperty(value="Privileged")
        private boolean privileged;
        @JsonProperty(value="Dns")
        private String dns;
        @JsonProperty(value="VolumesFrom")
        private String volumesFrom;
        @JsonProperty(value="ContainerIDFile")
        private String containerIDFile;
        @JsonProperty(value="DnsSearch")
        private String dnsSearch;
        @JsonProperty(value="Links")
        private String[] links;
        @JsonProperty(value="NetworkMode")
        private String networkMode;

        public String[] getBinds() {
            return this.binds;
        }

        public LxcConf[] getLxcConf() {
            return this.lxcConf;
        }

        public Ports getPortBindings() {
            return this.portBindings;
        }

        public boolean isPublishAllPorts() {
            return this.publishAllPorts;
        }

        public boolean isPrivileged() {
            return this.privileged;
        }

        public String getDns() {
            return this.dns;
        }

        public String getVolumesFrom() {
            return this.volumesFrom;
        }

        public String getContainerIDFile() {
            return this.containerIDFile;
        }

        public String getDnsSearch() {
            return this.dnsSearch;
        }

        public String[] getLinks() {
            return this.links;
        }

        public String getNetworkMode() {
            return this.networkMode;
        }

        public String toString() {
            return "HostConfig{binds=" + Arrays.toString(this.binds) + ", containerIDFile='" + this.containerIDFile + '\'' + ", lxcConf=" + Arrays.toString(this.lxcConf) + ", links=" + Arrays.toString(this.links) + ", portBindings=" + this.portBindings + ", privileged=" + this.privileged + ", publishAllPorts=" + this.publishAllPorts + ", networkMode=" + this.networkMode + ", dns='" + this.dns + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class ContainerState {
        @JsonProperty(value="Running")
        private boolean running;
        @JsonProperty(value="Paused")
        private boolean paused;
        @JsonProperty(value="Pid")
        private int pid;
        @JsonProperty(value="ExitCode")
        private int exitCode;
        @JsonProperty(value="StartedAt")
        private String startedAt;
        @JsonProperty(value="FinishedAt")
        private String finishedAt;

        public boolean isRunning() {
            return this.running;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public int getPid() {
            return this.pid;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getStartedAt() {
            return this.startedAt;
        }

        public String getFinishedAt() {
            return this.finishedAt;
        }

        public String toString() {
            return "ContainerState{running=" + this.running + ", paused=" + this.paused + ", pid=" + this.pid + ", exitCode=" + this.exitCode + ", startedAt='" + this.startedAt + '\'' + ", finishedAt='" + this.finishedAt + '\'' + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class NetworkSettings {
        @JsonProperty(value="IPAddress")
        private String ipAddress;
        @JsonProperty(value="IPPrefixLen")
        private int ipPrefixLen;
        @JsonProperty(value="Gateway")
        private String gateway;
        @JsonProperty(value="Bridge")
        private String bridge;
        @JsonProperty(value="PortMapping")
        private Map<String, Map<String, String>> portMapping;
        @JsonProperty(value="Ports")
        private Ports ports;

        public String getIpAddress() {
            return this.ipAddress;
        }

        public int getIpPrefixLen() {
            return this.ipPrefixLen;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getBridge() {
            return this.bridge;
        }

        public Map<String, Map<String, String>> getPortMapping() {
            return this.portMapping;
        }

        public Ports getPorts() {
            return this.ports;
        }

        public String toString() {
            return "NetworkSettings{ports=" + this.ports + ", portMapping=" + this.portMapping + ", bridge='" + this.bridge + '\'' + ", gateway='" + this.gateway + '\'' + ", ipPrefixLen=" + this.ipPrefixLen + ", ipAddress='" + this.ipAddress + '\'' + '}';
        }
    }
}

