/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.client.model.ExposedPort;
import com.github.dockerjava.client.model.ExposedPorts;
import com.github.dockerjava.client.model.Volume;
import com.github.dockerjava.client.model.Volumes;
import java.util.Arrays;

public class CreateContainerConfig {
    @JsonProperty(value="Hostname")
    private String hostName = "";
    @JsonProperty(value="User")
    private String user = "";
    @JsonProperty(value="Memory")
    private long memoryLimit = 0L;
    @JsonProperty(value="MemorySwap")
    private long memorySwap = 0L;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin = false;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout = false;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr = false;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private boolean tty = false;
    @JsonProperty(value="OpenStdin")
    private boolean stdinOpen = false;
    @JsonProperty(value="StdinOnce")
    private boolean stdInOnce = false;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="VolumesFrom")
    private String volumesFrom = "";
    @JsonProperty(value="WorkingDir")
    private String workingDir = "";
    @JsonProperty(value="DisableNetwork")
    private boolean disableNetwork = false;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);

    public CreateContainerConfig withExposedPorts(ExposedPort[] exposedPorts) {
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    @JsonIgnore
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    public boolean isDisableNetwork() {
        return this.disableNetwork;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public CreateContainerConfig withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public CreateContainerConfig withDisableNetwork(boolean disableNetwork) {
        this.disableNetwork = disableNetwork;
        return this;
    }

    public CreateContainerConfig withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    public CreateContainerConfig withPortSpecs(String[] portSpecs) {
        this.portSpecs = portSpecs;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public CreateContainerConfig withUser(String user) {
        this.user = user;
        return this;
    }

    public boolean isTty() {
        return this.tty;
    }

    public CreateContainerConfig withTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    public boolean isStdinOpen() {
        return this.stdinOpen;
    }

    public CreateContainerConfig withStdinOpen(boolean stdinOpen) {
        this.stdinOpen = stdinOpen;
        return this;
    }

    public boolean isStdInOnce() {
        return this.stdInOnce;
    }

    public CreateContainerConfig withStdInOnce(boolean stdInOnce) {
        this.stdInOnce = stdInOnce;
        return this;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public CreateContainerConfig withMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public long getMemorySwap() {
        return this.memorySwap;
    }

    public CreateContainerConfig withMemorySwap(long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    public boolean isAttachStdin() {
        return this.attachStdin;
    }

    public CreateContainerConfig withAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    public boolean isAttachStdout() {
        return this.attachStdout;
    }

    public CreateContainerConfig withAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    public boolean isAttachStderr() {
        return this.attachStderr;
    }

    public CreateContainerConfig withAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    public String[] getEnv() {
        return this.env;
    }

    public CreateContainerConfig withEnv(String[] env) {
        this.env = env;
        return this;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public CreateContainerConfig withCmd(String[] cmd) {
        this.cmd = cmd;
        return this;
    }

    public String[] getDns() {
        return this.dns;
    }

    public CreateContainerConfig withDns(String[] dns) {
        this.dns = dns;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public CreateContainerConfig withImage(String image) {
        this.image = image;
        return this;
    }

    @JsonIgnore
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    public CreateContainerConfig withVolumes(Volume[] volumes) {
        this.volumes = new Volumes(volumes);
        return this;
    }

    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    public CreateContainerConfig withVolumesFrom(String volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public String toString() {
        return "CreateContainerConfig{hostName='" + this.hostName + '\'' + ", portSpecs=" + Arrays.toString(this.portSpecs) + ", user='" + this.user + '\'' + ", tty=" + this.tty + ", stdinOpen=" + this.stdinOpen + ", stdInOnce=" + this.stdInOnce + ", memoryLimit=" + this.memoryLimit + ", memorySwap=" + this.memorySwap + ", attachStdin=" + this.attachStdin + ", attachStdout=" + this.attachStdout + ", attachStderr=" + this.attachStderr + ", env=" + Arrays.toString(this.env) + ", cmd=" + Arrays.toString(this.cmd) + ", dns=" + Arrays.toString(this.dns) + ", image='" + this.image + '\'' + ", volumes=" + this.volumes + ", volumesFrom='" + this.volumesFrom + '\'' + ", disableNetwork=" + this.disableNetwork + ", workingDir='" + this.workingDir + '\'' + '}';
    }
}

