/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.client.model.ExposedPort;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Ports {
    private final Map<ExposedPort, Binding> ports = new HashMap<ExposedPort, Binding>();

    public Ports() {
    }

    public Ports(ExposedPort exposedPort, Binding host) {
        this.bind(exposedPort, host);
    }

    public void bind(ExposedPort exposedPort, Binding host) {
        this.ports.put(exposedPort, host);
    }

    public String toString() {
        return this.ports.toString();
    }

    public Map<ExposedPort, Binding> getBindings() {
        return this.ports;
    }

    public static Binding Binding(String hostIp, int hostPort) {
        return new Binding(hostIp, hostPort);
    }

    public static Binding Binding(int hostPort) {
        return new Binding(hostPort);
    }

    public static class Serializer
    extends JsonSerializer<Ports> {
        public void serialize(Ports portBindings, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (Map.Entry<ExposedPort, Binding> entry : portBindings.getBindings().entrySet()) {
                jsonGen.writeFieldName(entry.getKey().getPort() + "/" + entry.getKey().getScheme());
                jsonGen.writeStartArray();
                jsonGen.writeStartObject();
                jsonGen.writeStringField("HostIp", entry.getValue().getHostIp());
                jsonGen.writeStringField("HostPort", "" + entry.getValue().getHostPort());
                jsonGen.writeEndObject();
                jsonGen.writeEndArray();
            }
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Ports> {
        public Ports deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Ports out = new Ports();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                if (((JsonNode)field.getValue()).equals((Object)NullNode.getInstance())) continue;
                String hostIp = ((JsonNode)field.getValue()).get(0).get("HostIp").textValue();
                int hostPort = ((JsonNode)field.getValue()).get(0).get("HostPort").asInt();
                out.bind(ExposedPort.parse((String)field.getKey()), new Binding(hostIp, hostPort));
            }
            return out;
        }
    }

    public static class Binding {
        private final String hostIp;
        private final int hostPort;

        public Binding(String hostIp, int hostPort) {
            this.hostIp = hostIp;
            this.hostPort = hostPort;
        }

        public Binding(int hostPort) {
            this("", hostPort);
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public int getHostPort() {
            return this.hostPort;
        }

        public String toString() {
            return "PortBinding{hostIp='" + this.hostIp + '\'' + ", hostPort='" + this.hostPort + '\'' + '}';
        }

        public boolean equals(Object obj) {
            if (obj instanceof Binding) {
                Binding other = (Binding)obj;
                return new EqualsBuilder().append((Object)this.hostIp, (Object)other.getHostIp()).append(this.hostPort, other.getHostPort()).isEquals();
            }
            return super.equals(obj);
        }
    }
}

