/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Volume {
    private String path;
    private boolean readWrite = true;

    public Volume(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public static Volume parse(String serialized) {
        return new Volume(serialized);
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Volume) {
            Volume other = (Volume)obj;
            return new EqualsBuilder().append((Object)this.path, (Object)other.getPath()).append(this.readWrite, other.isReadWrite()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).append(this.readWrite).toHashCode();
    }

    public static class Deserializer
    extends JsonDeserializer<Volume> {
        public Volume deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (!node.equals((Object)NullNode.getInstance())) {
                Map.Entry field = (Map.Entry)node.fields().next();
                return Volume.parse((String)field.getKey());
            }
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Volume> {
        public void serialize(Volume volume, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            jsonGen.writeFieldName(volume.getPath());
            jsonGen.writeString(Boolean.toString(volume.isReadWrite()));
            jsonGen.writeEndObject();
        }
    }
}

