/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.ResponseElement;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.recorder.DynamicRecordHandler;
import com.github.dreamhead.moco.recorder.DynamicReplayHandler;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.recorder.RecorderConfigurations;
import com.github.dreamhead.moco.recorder.RecorderGroup;
import com.github.dreamhead.moco.recorder.RecorderIdentifier;
import com.github.dreamhead.moco.recorder.RecorderTape;
import com.github.dreamhead.moco.recorder.ReplayModifier;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.util.Iterables;
import com.github.dreamhead.moco.util.Preconditions;

public final class MocoRecorders {
    public static ResponseHandler record(RecorderConfig config, RecorderConfig ... configs) {
        RecorderConfigurations configurations = RecorderConfigurations.create(Iterables.asIterable(com.google.common.base.Preconditions.checkNotNull((Object)config, (Object)"Configuration should not be null"), (Object[])com.google.common.base.Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null")));
        return new DynamicRecordHandler(configurations);
    }

    public static ResponseHandler replay(RecorderConfig config, RecorderConfig ... configs) {
        return new DynamicReplayHandler(RecorderConfigurations.create(Iterables.asIterable(com.google.common.base.Preconditions.checkNotNull((Object)config, (Object)"Configuration should not be null"), (Object[])com.google.common.base.Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null"))));
    }

    public static RecorderGroup group(String name) {
        return new RecorderGroup(Preconditions.checkNotNullOrEmpty(name, "Identifier should not be empty"));
    }

    public static RecorderTape tape(String path) {
        return new RecorderTape(Preconditions.checkNotNullOrEmpty(path, "Identifier should not be empty"));
    }

    public static RecorderIdentifier identifier(String text) {
        return new RecorderIdentifier(Moco.template(Preconditions.checkNotNullOrEmpty(text, "Identifier should not be empty")));
    }

    public static RecorderIdentifier identifier(ContentResource text) {
        return new RecorderIdentifier((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)text, (Object)"Identifier should not be empty"));
    }

    public static ReplayModifier modifier(String text) {
        return new ReplayModifier(Moco.with(Moco.template(Preconditions.checkNotNullOrEmpty(text, "Modifier should not be empty"))));
    }

    public static ReplayModifier modifier(ResponseElement element, ResponseElement ... elements) {
        return new ReplayModifier(Moco.and((ResponseElement)com.google.common.base.Preconditions.checkNotNull((Object)element, (Object)"Response should not be null"), (ResponseElement[])com.google.common.base.Preconditions.checkNotNull((Object)elements, (Object)"Responses should not be null")));
    }

    private MocoRecorders() {
    }
}

