/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.action;

import com.github.dreamhead.moco.HttpHeader;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.action.MocoRequestAction;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

public final class MocoPostRequestAction
extends MocoRequestAction {
    private final ContentResource content;

    public MocoPostRequestAction(Resource url, ContentResource content, HttpHeader[] headers) {
        super(url, headers);
        this.content = content;
    }

    @Override
    protected HttpUriRequest createRequest(String url, Request request) {
        HttpPost targetRequest = new HttpPost(url);
        targetRequest.setEntity(this.asEntity(this.content, request));
        return targetRequest;
    }

    private HttpEntity asEntity(ContentResource resource, Request request) {
        return new ByteArrayEntity(resource.readFor(request).getContent(), this.getContentType((HttpRequest)request));
    }

    private ContentType getContentType(HttpRequest request) {
        MediaType type = this.content.getContentType(request);
        return ContentType.create((String)(type.type() + "/" + type.subtype()), (Charset)((Charset)type.charset().or((Object)Charset.defaultCharset())));
    }

    @Override
    public MocoEventAction apply(MocoConfig config) {
        Resource appliedUrl = this.applyUrl(config);
        Resource appliedContent = this.content.apply(config);
        HttpHeader[] headers = this.applyHeaders(config);
        if (this.isSameUrl(appliedUrl) && appliedContent == this.content && this.isSameHeaders(headers)) {
            return this;
        }
        return new MocoPostRequestAction(appliedUrl, (ContentResource)appliedContent, headers);
    }
}

