/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.action;

import com.github.dreamhead.moco.HttpHeader;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import java.io.IOException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public abstract class MocoRequestAction
implements MocoEventAction {
    private final Resource url;
    private final HttpHeader[] headers;

    protected abstract HttpUriRequest createRequest(String var1, Request var2);

    protected MocoRequestAction(Resource url, HttpHeader[] headers) {
        this.url = url;
        this.headers = headers;
    }

    @Override
    public final void execute(Request request) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            client.execute(this.prepareRequest(request));
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private HttpUriRequest prepareRequest(Request request) {
        HttpUriRequest httpRequest = this.createRequest(this.url.readFor(request).toString(), request);
        for (HttpHeader header : this.headers) {
            httpRequest.addHeader(header.getName(), header.getValue().readFor(request).toString());
        }
        return httpRequest;
    }

    protected final Resource applyUrl(MocoConfig config) {
        Resource appliedResource = this.url.apply(config);
        if (appliedResource == this.url) {
            return this.url;
        }
        return appliedResource;
    }

    protected final boolean isSameUrl(Resource url) {
        return this.url == url;
    }

    protected final HttpHeader[] applyHeaders(MocoConfig config) {
        HttpHeader[] appliedHeaders = new HttpHeader[this.headers.length];
        boolean applied = false;
        for (int i = 0; i < this.headers.length; ++i) {
            HttpHeader appliedHeader = this.headers[i].apply(config);
            if (!this.headers[i].equals(appliedHeader)) {
                applied = true;
            }
            appliedHeaders[i] = appliedHeader;
        }
        if (applied) {
            return appliedHeaders;
        }
        return this.headers;
    }

    protected final boolean isSameHeaders(HttpHeader[] headers) {
        return this.headers == headers;
    }
}

