/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.extractor.HttpMethodExtractor;
import com.github.dreamhead.moco.extractor.UriRequestExtractor;
import com.github.dreamhead.moco.extractor.VersionExtractor;
import com.google.common.collect.ImmutableMap;

public final class Extractors {
    private static ImmutableMap<String, RequestExtractor<?>> extractors = ImmutableMap.builder().put((Object)"file", (Object)new ContentRequestExtractor()).put((Object)"text", (Object)new ContentRequestExtractor()).put((Object)"pathresource", (Object)new ContentRequestExtractor()).put((Object)"json", (Object)new ContentRequestExtractor()).put((Object)"uri", (Object)new UriRequestExtractor()).put((Object)"method", (Object)new HttpMethodExtractor()).put((Object)"version", (Object)new VersionExtractor()).build();

    public static RequestExtractor<?> extractor(String id) {
        if (extractors.containsKey((Object)id)) {
            return (RequestExtractor)extractors.get((Object)id);
        }
        throw new IllegalArgumentException(String.format("unknown extractor for [%s]", id));
    }

    private Extractors() {
    }
}

