/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler.failover;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.handler.failover.FailoverExecutor;
import com.github.dreamhead.moco.model.HttpRequestFailoverMatcher;
import com.github.dreamhead.moco.model.Session;
import com.github.dreamhead.moco.util.Jsons;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFailoverExecutor
implements FailoverExecutor {
    private static Logger logger = LoggerFactory.getLogger(DefaultFailoverExecutor.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final File file;

    public DefaultFailoverExecutor(File file) {
        this.file = file;
    }

    @Override
    public void onCompleteResponse(HttpRequest request, HttpResponse response) {
        try {
            ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
            Session targetSession = Session.newSession(request, response);
            writer.writeValue(this.file, this.prepareTargetSessions(this.file, targetSession));
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private ImmutableList<Session> prepareTargetSessions(File file, Session targetSession) {
        if (file.length() == 0L) {
            return ImmutableList.of((Object)targetSession);
        }
        return ImmutableList.builder().addAll(this.toUniqueSessions(targetSession, this.restoreSessions(file))).add((Object)targetSession).build();
    }

    private Iterable<Session> toUniqueSessions(Session targetSession, ImmutableList<Session> sessions) {
        Optional<Session> session = sessions.stream().filter(this.isForRequest(targetSession.getRequest())).findFirst();
        if (session.isPresent()) {
            return sessions.stream().filter(this.isForRequest(targetSession.getRequest()).negate()).collect(Collectors.toList());
        }
        return sessions;
    }

    private ImmutableList<Session> restoreSessions(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return Jsons.toObjects(inputStream, Session.class);
        }
        catch (MocoException me) {
            logger.error("exception found", (Throwable)me);
            return ImmutableList.of();
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    @Override
    public HttpResponse failover(HttpRequest request) {
        ImmutableList<Session> sessions = this.restoreSessions(this.file);
        Optional<Session> session = sessions.stream().filter(this.isForRequest(request)).findFirst();
        if (session.isPresent()) {
            return session.get().getResponse();
        }
        logger.error("No match request found: {}", (Object)request);
        throw new MocoException("no failover response found");
    }

    private Predicate<Session> isForRequest(HttpRequest dumpedRequest) {
        return session -> {
            HttpRequest request = session.getRequest();
            return new HttpRequestFailoverMatcher(request).match(dumpedRequest);
        };
    }
}

