/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.model.DefaultHttpMessage;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import java.io.InputStream;

@JsonDeserialize(builder=Builder.class)
public final class DefaultHttpResponse
extends DefaultHttpMessage
implements HttpResponse {
    private final int status;

    public DefaultHttpResponse(HttpProtocolVersion version, int status, ImmutableMap<String, String[]> headers, MessageContent content) {
        super(version, content, headers);
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("status", this.status);
    }

    public static HttpResponse newResponse(FullHttpResponse response) {
        return ((Builder)((Builder)((Builder)DefaultHttpResponse.builder().withVersion(DefaultHttpResponse.toHttpProtocolVersion(response.protocolVersion()))).withStatus(response.status().code()).withHeaders(DefaultHttpResponse.toHeaders((HttpMessage)response))).withContent(MessageContent.content().withContent((InputStream)new ByteBufInputStream(response.content())).build())).build();
    }

    private static HttpProtocolVersion toHttpProtocolVersion(HttpVersion httpVersion) {
        return HttpProtocolVersion.versionOf(httpVersion.text());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends DefaultHttpMessage.Builder<Builder> {
        private int status;

        public Builder withStatus(int code) {
            this.status = code;
            return this;
        }

        public DefaultHttpResponse build() {
            return new DefaultHttpResponse(this.getVersion(), this.status, this.getHeaders(), this.getContent());
        }
    }
}

