/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.recorder.RecorderFactory;
import com.github.dreamhead.moco.recorder.RecorderGroup;
import com.github.dreamhead.moco.recorder.RecorderIdentifier;
import com.github.dreamhead.moco.recorder.RecorderRegistry;
import com.github.dreamhead.moco.recorder.RecorderTape;
import com.github.dreamhead.moco.recorder.ReplayModifier;
import com.github.dreamhead.moco.recorder.TapeRecorderFactory;

public class RecorderConfigurations {
    private RecorderGroup group;
    private RecorderTape tape;
    private RecorderIdentifier identifier;
    private ReplayModifier modifier;

    public static RecorderConfigurations create(Iterable<RecorderConfig> configs) {
        RecorderConfigurations configurations = new RecorderConfigurations();
        for (RecorderConfig config : configs) {
            if (config.isFor("group")) {
                configurations.group = (RecorderGroup)config;
                continue;
            }
            if (config.isFor("tape")) {
                configurations.tape = (RecorderTape)config;
                continue;
            }
            if (config.isFor("identifier")) {
                configurations.identifier = (RecorderIdentifier)config;
                continue;
            }
            if (config.isFor("modifier")) {
                configurations.modifier = (ReplayModifier)config;
                continue;
            }
            throw new IllegalArgumentException("Unknown recorder config:" + config);
        }
        return configurations;
    }

    public final RecorderRegistry getRecorderRegistry() {
        if (this.group != null) {
            return RecorderRegistry.registryOf(this.group.getName(), this.getRecordFactory());
        }
        return RecorderRegistry.defaultRegistry();
    }

    private RecorderFactory getRecordFactory() {
        if (this.tape != null) {
            return new TapeRecorderFactory(this.tape);
        }
        return RecorderFactory.IN_MEMORY;
    }

    public final RecorderIdentifier getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        if (this.group != null) {
            return new RecorderIdentifier(Moco.text(this.group.getName()));
        }
        throw new IllegalArgumentException("No identifier found");
    }

    public final ReplayModifier getModifier() {
        if (this.modifier != null) {
            return this.modifier;
        }
        return new ReplayModifier(Moco.with(Moco.template("${req.content}")));
    }
}

