/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import java.util.Optional;

public final class FileContentType {
    public static final MediaType DEFAULT_CONTENT_TYPE_WITH_CHARSET = MediaType.PLAIN_TEXT_UTF_8;
    private static final ImmutableMap<String, MediaType> CONTENT_TYPES = ImmutableMap.builder().put((Object)"png", (Object)MediaType.PNG).put((Object)"gif", (Object)MediaType.GIF).put((Object)"jpg", (Object)MediaType.JPEG).put((Object)"jpeg", (Object)MediaType.JPEG).put((Object)"tiff", (Object)MediaType.TIFF).put((Object)"css", (Object)MediaType.create((String)"text", (String)"css")).put((Object)"html", (Object)MediaType.create((String)"text", (String)"html")).put((Object)"txt", (Object)MediaType.create((String)"text", (String)"plain")).put((Object)"js", (Object)MediaType.create((String)"application", (String)"javascript")).put((Object)"json", (Object)MediaType.create((String)"application", (String)"json")).put((Object)"pdf", (Object)MediaType.PDF).put((Object)"zip", (Object)MediaType.ZIP).put((Object)"tar", (Object)MediaType.TAR).put((Object)"gz", (Object)MediaType.GZIP).put((Object)"xml", (Object)MediaType.create((String)"text", (String)"xml")).build();
    private final String filename;
    private final Charset charset;

    public FileContentType(String filename) {
        this(filename, null);
    }

    public FileContentType(String filename, Charset charset) {
        this.filename = filename;
        this.charset = charset;
    }

    public MediaType getContentType() {
        Optional<MediaType> optionalType = this.toContentType(Files.getFileExtension((String)this.filename));
        Optional<Charset> targetCharset = this.toCharset(optionalType.orElse(null));
        MediaType type = optionalType.orElse(DEFAULT_CONTENT_TYPE_WITH_CHARSET);
        if (targetCharset.isPresent() && !type.charset().equals(targetCharset)) {
            return type.withCharset(targetCharset.get());
        }
        return type;
    }

    private Optional<Charset> toCharset(MediaType type) {
        if (this.charset != null) {
            return Optional.of(this.charset);
        }
        if (type == null) {
            return Optional.of(Charsets.UTF_8);
        }
        return type.charset().toJavaUtil();
    }

    private Optional<MediaType> toContentType(String extension) {
        return Optional.ofNullable(CONTENT_TYPES.get((Object)extension.toLowerCase()));
    }
}

