/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.github.dreamhead.moco.MocoException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public final class Globs {
    private static final String GLOB_META_CHARS = "\\*?[{";

    public static ImmutableList<String> glob(String glob) {
        Path path = Globs.getGlobPath(glob);
        int globIndex = Globs.getGlobIndex(path);
        if (globIndex < 0) {
            return ImmutableList.of((Object)glob);
        }
        return Globs.doGlob(path, Globs.searchPath(path, globIndex));
    }

    private static Path getGlobPath(String glob) {
        Path path = Paths.get(glob, new String[0]);
        if (Globs.isCurrentPath(path)) {
            return Paths.get(".", new String[0]).resolve(path);
        }
        return path;
    }

    private static boolean isCurrentPath(Path path) {
        return path.getNameCount() == 1;
    }

    private static Path searchPath(Path path, int globIndex) {
        Path root = path.getRoot();
        Path subpath = path.subpath(0, globIndex);
        if (root == null) {
            return subpath;
        }
        return Paths.get(root.toString(), subpath.toString());
    }

    private static ImmutableList<String> doGlob(Path path, Path searchPath) {
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + path);
        try {
            final ImmutableList.Builder builder = ImmutableList.builder();
            Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        builder.add((Object)file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return builder.build();
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private static int getGlobIndex(Path path) {
        int nameCount = path.getNameCount();
        for (int i = 0; i < nameCount; ++i) {
            String current = path.getName(i).toString();
            int length = current.length();
            for (int j = 0; j < length; ++j) {
                if (!Globs.isGlobMeta(current.charAt(j))) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isGlobMeta(char c) {
        return GLOB_META_CHARS.indexOf(c) != -1;
    }

    private Globs() {
    }
}

