/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format.util;

import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class TextUtils {
    private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
    private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
    private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);
    private static final Pattern DIGITS = Pattern.compile("[0-9]", 2);
    private static final int BUFFER_SIZE = 4096;

    public static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    public static BigInteger unsignedLong(long value) {
        if (value < 0L) {
            return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63);
        }
        return BigInteger.valueOf(value);
    }

    public static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    public static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static boolean isDigits(String text) {
        return DIGITS.matcher(text).matches();
    }

    public static StringBuilder toStringBuilder(Readable input) throws IOException {
        int n;
        StringBuilder text = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(4096);
        while ((n = input.read(buffer)) != -1) {
            buffer.flip();
            text.append(buffer, 0, n);
        }
        return text;
    }

    public static InputStream toInputStream(String input) {
        return TextUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String input, Charset cs) {
        return new ByteArrayInputStream(input.getBytes(cs));
    }

    public static double parseDouble(String text) throws NumberFormatException {
        if (DOUBLE_INFINITY.matcher(text).matches()) {
            boolean negative = text.startsWith("-");
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (text.equalsIgnoreCase("nan")) {
            return Double.NaN;
        }
        double result = Double.parseDouble(text);
        return result;
    }

    public static float parseFloat(String text) throws NumberFormatException {
        if (FLOAT_INFINITY.matcher(text).matches()) {
            boolean negative = text.startsWith("-");
            return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (FLOAT_NAN.matcher(text).matches()) {
            return Float.NaN;
        }
        float result = Float.parseFloat(text);
        return result;
    }

    public static boolean parseBoolean(String text) throws IllegalArgumentException {
        if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("t") || text.equals("1")) {
            return true;
        }
        if (text.equalsIgnoreCase("false") || text.equalsIgnoreCase("f") || text.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Expected \"true\" or \"false\".");
    }

    public static int parseInt32(String text) throws NumberFormatException {
        return (int)TextUtils.parseInteger(text, true, false);
    }

    public static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextUtils.parseInteger(text, false, false);
    }

    public static long parseInt64(String text) throws NumberFormatException {
        return TextUtils.parseInteger(text, true, true);
    }

    public static long parseUInt64(String text) throws NumberFormatException {
        return TextUtils.parseInteger(text, false, true);
    }

    public static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    public static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    public static ByteString unescapeBytes(CharSequence charString) {
        ByteString input = ByteString.copyFromUtf8((String)charString.toString());
        byte[] result = new byte[input.size()];
        int pos = 0;
        block13: for (int i = 0; i < input.size(); ++i) {
            byte c = input.byteAt(i);
            if (c == 92) {
                if (i + 1 < input.size()) {
                    int code;
                    if (TextUtils.isOctal((char)(c = input.byteAt(++i)))) {
                        code = TextUtils.digitValue((char)c);
                        if (i + 1 < input.size() && TextUtils.isOctal((char)input.byteAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue((char)input.byteAt(++i));
                        }
                        if (i + 1 < input.size() && TextUtils.isOctal((char)input.byteAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue((char)input.byteAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result[pos++] = 7;
                            continue block13;
                        }
                        case 98: {
                            result[pos++] = 8;
                            continue block13;
                        }
                        case 102: {
                            result[pos++] = 12;
                            continue block13;
                        }
                        case 110: {
                            result[pos++] = 10;
                            continue block13;
                        }
                        case 114: {
                            result[pos++] = 13;
                            continue block13;
                        }
                        case 116: {
                            result[pos++] = 9;
                            continue block13;
                        }
                        case 118: {
                            result[pos++] = 11;
                            continue block13;
                        }
                        case 92: {
                            result[pos++] = 92;
                            continue block13;
                        }
                        case 39: {
                            result[pos++] = 39;
                            continue block13;
                        }
                        case 34: {
                            result[pos++] = 34;
                            continue block13;
                        }
                        case 120: {
                            code = 0;
                            if (i + 1 >= input.size() || !TextUtils.isHex((char)input.byteAt(i + 1))) {
                                throw new IllegalArgumentException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextUtils.digitValue((char)input.byteAt(++i));
                            if (i + 1 < input.size() && TextUtils.isHex((char)input.byteAt(i + 1))) {
                                code = code * 16 + TextUtils.digitValue((char)input.byteAt(++i));
                            }
                            result[pos++] = (byte)code;
                            continue block13;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid escape sequence: '\\" + (char)c + '\'');
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = c;
        }
        return ByteString.copyFrom((byte[])result, (int)0, (int)pos);
    }
}

