/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.VisitablePredicate;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.predicates.BetweenVisitor;
import com.hazelcast.query.impl.predicates.FlatteningVisitor;
import com.hazelcast.query.impl.predicates.OrToInVisitor;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.query.impl.predicates.Visitor;

public final class RuleBasedQueryOptimizer
implements QueryOptimizer {
    private final Visitor betweenVisitor = new BetweenVisitor();
    private final Visitor flatteningVisitor = new FlatteningVisitor();
    private final Visitor orToInVisitor = new OrToInVisitor();

    @Override
    public <K, V> Predicate<K, V> optimize(Predicate<K, V> predicate, Indexes indexes) {
        Predicate optimized = predicate;
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.flatteningVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.betweenVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.orToInVisitor, indexes);
        }
        return optimized;
    }
}

