/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfig
implements Config {
    private final Map<String, Object> properties;
    private final Map<String, Boolean> features;
    private final Map<String, String> declaredNamespaces;
    private final boolean namespaceAware;
    private final boolean isUserConfigured;

    public XmlConfig() {
        this(new HashMap<String, Boolean>(), new HashMap<String, String>(), new HashMap<String, Object>(), false, false);
    }

    private XmlConfig(Map<String, Boolean> features, Map<String, String> declaredNamespaces, Map<String, Object> properties, boolean namespaceAware, boolean isUserConfigured) {
        Validate.notNull(features, (String)"Features cannot be null", (Object[])new Object[0]);
        Validate.notNull(declaredNamespaces, (String)"Declared namespaces cannot be null", (Object[])new Object[0]);
        Validate.notNull(properties, (String)"Properties cannot be null", (Object[])new Object[0]);
        this.namespaceAware = namespaceAware;
        this.features = features;
        this.declaredNamespaces = declaredNamespaces;
        this.properties = properties;
        this.isUserConfigured = isUserConfigured;
    }

    public Map<String, Boolean> features() {
        return new HashMap<String, Boolean>(this.features);
    }

    public Map<String, Object> properties() {
        return new HashMap<String, Object>(this.properties);
    }

    public XmlConfig features(Map<String, Boolean> features) {
        return new XmlConfig(features, this.declaredNamespaces, this.properties, this.namespaceAware, true);
    }

    public XmlConfig properties(Map<String, Object> properties) {
        return new XmlConfig(this.features, this.declaredNamespaces, this.properties, this.namespaceAware, true);
    }

    public XmlConfig feature(String uri, boolean enabled) {
        Validate.notEmpty((CharSequence)uri, (String)"URI cannot be empty", (Object[])new Object[0]);
        HashMap<String, Boolean> newFeatures = new HashMap<String, Boolean>(this.features);
        newFeatures.put(uri, enabled);
        return new XmlConfig(newFeatures, this.declaredNamespaces, this.properties, this.namespaceAware, true);
    }

    public XmlConfig property(String name, Object value) {
        Validate.notEmpty((CharSequence)name, (String)"Name cannot be empty", (Object[])new Object[0]);
        HashMap<String, Object> newProperties = new HashMap<String, Object>(this.properties);
        newProperties.put(name, value);
        return new XmlConfig(this.features, this.declaredNamespaces, newProperties, this.namespaceAware, true);
    }

    public Map<String, String> declaredNamespaces() {
        return new HashMap<String, String>(this.declaredNamespaces);
    }

    public XmlConfig declareNamespaces(Map<String, String> namespacesToDeclare) {
        boolean shouldBeNamespaceAware = namespacesToDeclare == null ? this.namespaceAware : !namespacesToDeclare.isEmpty();
        return new XmlConfig(this.features, namespacesToDeclare, this.properties, shouldBeNamespaceAware, true);
    }

    public XmlConfig declareNamespace(String prefix, String namespaceURI) {
        Validate.notEmpty((CharSequence)prefix, (String)"Prefix cannot be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)namespaceURI, (String)"Namespace URI cannot be empty", (Object[])new Object[0]);
        HashMap<String, String> updatedNamespaces = new HashMap<String, String>(this.declaredNamespaces);
        updatedNamespaces.put(prefix, namespaceURI);
        return new XmlConfig(this.features, updatedNamespaces, this.properties, true, true);
    }

    public XmlConfig disableLoadingOfExternalDtd() {
        HashMap<String, Boolean> newFeatures = new HashMap<String, Boolean>(this.features);
        newFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return new XmlConfig(newFeatures, this.declaredNamespaces, this.properties, this.namespaceAware, true);
    }

    public XmlConfig namespaceAware(boolean shouldBeAwareOfNamespaces) {
        return new XmlConfig(this.features, this.declaredNamespaces, this.properties, shouldBeAwareOfNamespaces, true);
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public XmlConfig with() {
        return this;
    }

    public XmlConfig and() {
        return this;
    }

    public static XmlConfig xmlConfig() {
        return new XmlConfig();
    }

    @Override
    public boolean isUserConfigured() {
        return this.isUserConfigured;
    }
}

