/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.netflix.governator.configuration.AbstractObjectConfigurationProvider;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.DateWithDefaultProperty;
import com.netflix.governator.configuration.Property;
import java.util.Date;
import java.util.Map;

public class SystemConfigurationProvider
extends AbstractObjectConfigurationProvider {
    private final Map<String, String> variableValues;

    public SystemConfigurationProvider() {
        this(Maps.newHashMap());
    }

    public SystemConfigurationProvider(Map<String, String> variableValues) {
        this(variableValues, null);
    }

    public SystemConfigurationProvider(Map<String, String> variableValues, ObjectMapper objectMapper) {
        super(objectMapper);
        this.variableValues = Maps.newHashMap(variableValues);
    }

    public void setVariable(String name, String value) {
        this.variableValues.put(name, value);
    }

    @Override
    public boolean has(ConfigurationKey key) {
        return System.getProperty(key.getKey(this.variableValues), null) != null;
    }

    @Override
    public Property<Boolean> getBooleanProperty(final ConfigurationKey key, final Boolean defaultValue) {
        return new Property<Boolean>(){

            @Override
            public Boolean get() {
                String value = System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues));
                if (value == null) {
                    return defaultValue;
                }
                return Boolean.parseBoolean(value);
            }
        };
    }

    @Override
    public Property<Integer> getIntegerProperty(final ConfigurationKey key, final Integer defaultValue) {
        return new Property<Integer>(){

            @Override
            public Integer get() {
                Integer value;
                try {
                    value = Integer.parseInt(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Property<Long> getLongProperty(final ConfigurationKey key, final Long defaultValue) {
        return new Property<Long>(){

            @Override
            public Long get() {
                Long value;
                try {
                    value = Long.parseLong(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Property<Double> getDoubleProperty(final ConfigurationKey key, final Double defaultValue) {
        return new Property<Double>(){

            @Override
            public Double get() {
                Double value;
                try {
                    value = Double.parseDouble(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Property<String> getStringProperty(final ConfigurationKey key, final String defaultValue) {
        return new Property<String>(){

            @Override
            public String get() {
                String value = System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues));
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Property<Date> getDateProperty(ConfigurationKey key, Date defaultValue) {
        return new DateWithDefaultProperty(this.getStringProperty(key, null), defaultValue);
    }
}

