/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.InternalAutoBindModule;
import com.netflix.governator.guice.InternalAutoBindModuleBootstrapModule;
import com.netflix.governator.guice.InternalBootstrapModule;
import com.netflix.governator.guice.InternalLifecycleModule;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.guice.LifecycleInjectorBuilderImpl;
import com.netflix.governator.guice.LifecycleInjectorBuilderSuite;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.guice.LoadersBootstrapModule;
import com.netflix.governator.guice.MemberInjectingInstanceProvider;
import com.netflix.governator.guice.ModuleTransformer;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.guice.annotations.Bootstrap;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import com.netflix.governator.guice.lazy.FineGrainedLazySingletonScope;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.lifecycle.ClasspathScanner;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleInjector {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleInjector.class);
    private final ClasspathScanner scanner;
    private final List<Module> modules;
    private final Collection<Class<?>> ignoreClasses;
    private final boolean ignoreAllClasses;
    private final LifecycleManager lifecycleManager;
    private final Injector injector;
    private final Stage stage;
    private final LifecycleInjectorMode mode;
    private Set<PostInjectorAction> actions;
    private Set<ModuleTransformer> transformers;

    public static LifecycleInjectorBuilder builder() {
        return new LifecycleInjectorBuilderImpl();
    }

    public static Injector bootstrap(Class<?> main) {
        return LifecycleInjector.bootstrap(main, (Module)null, new BootstrapModule[0]);
    }

    public static Injector bootstrap(Class<?> main, BootstrapModule ... externalBootstrapModules) {
        return LifecycleInjector.bootstrap(main, null, externalBootstrapModules);
    }

    private static BootstrapModule forAnnotation(final Annotation annot) {
        final Class<? extends Annotation> type = annot.annotationType();
        return new BootstrapModule(){

            @Override
            public void configure(BootstrapBinder binder) {
                binder.bind(Key.get((Class)type)).toProvider(new Provider(){

                    public Object get() {
                        return annot;
                    }
                }).in(Scopes.SINGLETON);
            }
        };
    }

    @Beta
    public static Injector bootstrap(final Class<?> main, final Module externalBindings, final BootstrapModule ... externalBootstrapModules) {
        final LifecycleInjectorBuilder builder = LifecycleInjector.builder();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                if (externalBindings != null) {
                    this.install(externalBindings);
                }
                Multibinder bootstrapModules = Multibinder.newSetBinder((Binder)this.binder(), BootstrapModule.class);
                Multibinder suites = Multibinder.newSetBinder((Binder)this.binder(), LifecycleInjectorBuilderSuite.class);
                if (externalBootstrapModules != null) {
                    for (BootstrapModule bootstrapModule : externalBootstrapModules) {
                        bootstrapModules.addBinding().toProvider(new MemberInjectingInstanceProvider<Object>(bootstrapModule));
                    }
                }
                for (final Annotation annot : main.getDeclaredAnnotations()) {
                    Class<? extends Annotation> type = annot.annotationType();
                    LOG.info("Found bootstrap annotation {}", (Object)type.getName());
                    Bootstrap bootstrap = type.getAnnotation(Bootstrap.class);
                    if (bootstrap == null) continue;
                    boolean added = false;
                    if (!bootstrap.value().equals(Bootstrap.NullLifecycleInjectorBuilderSuite.class)) {
                        LOG.info("Adding Suite {}", bootstrap.bootstrap());
                        suites.addBinding().to(bootstrap.value()).asEagerSingleton();
                        added = true;
                    }
                    if (!bootstrap.bootstrap().equals(Bootstrap.NullBootstrapModule.class)) {
                        Preconditions.checkState((!added ? 1 : 0) != 0, (Object)(bootstrap.annotationType().getName() + " already added as a LifecycleInjectorBuilderSuite"));
                        added = true;
                        LOG.info("Adding BootstrapModule {}", bootstrap.bootstrap());
                        bootstrapModules.addBinding().to(bootstrap.bootstrap()).asEagerSingleton();
                        builder.withAdditionalBootstrapModules(LifecycleInjector.forAnnotation(annot));
                    }
                    if (!bootstrap.module().equals(Bootstrap.NullModule.class)) {
                        Preconditions.checkState((!added ? 1 : 0) != 0, (Object)(bootstrap.annotationType().getName() + " already added as a BootstrapModule"));
                        added = true;
                        LOG.info("Adding Module {}", bootstrap.bootstrap());
                        builder.withAdditionalModuleClasses(bootstrap.module());
                        builder.withAdditionalBootstrapModules(LifecycleInjector.forAnnotation(annot));
                    }
                    this.bind(Key.get(type)).toProvider(new Provider(){

                        public Object get() {
                            return annot;
                        }
                    }).in(Scopes.SINGLETON);
                }
            }
        }});
        Set suites = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<LifecycleInjectorBuilderSuite>>(){}));
        for (LifecycleInjectorBuilderSuite suite : suites) {
            suite.configure(builder);
        }
        builder.withAdditionalBootstrapModules((Iterable)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<BootstrapModule>>(){})));
        if (Module.class.isAssignableFrom(main)) {
            try {
                builder.withAdditionalModuleClasses(main);
            }
            catch (Exception e) {
                throw new ProvisionException(String.format("Failed to create module for main class '%s'", main.getName()), (Throwable)e);
            }
        }
        return builder.build().createInjector();
    }

    public static ClasspathScanner createStandardClasspathScanner(Collection<String> basePackages) {
        return LifecycleInjector.createStandardClasspathScanner(basePackages, null);
    }

    public static ClasspathScanner createStandardClasspathScanner(Collection<String> basePackages, List<Class<? extends Annotation>> additionalAnnotations) {
        ArrayList annotations = Lists.newArrayList();
        annotations.add(AutoBindSingleton.class);
        annotations.add(Inject.class);
        annotations.add(javax.inject.Inject.class);
        annotations.add(Resource.class);
        annotations.add(Resources.class);
        if (additionalAnnotations != null) {
            annotations.addAll(additionalAnnotations);
        }
        return new ClasspathScanner(basePackages, annotations);
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public Injector createChildInjector(Module ... modules) {
        return this.createChildInjector(Arrays.asList(modules));
    }

    public Injector createChildInjector(Collection<Module> modules) {
        Collection<Module> localModules = modules;
        for (ModuleTransformer transformer : this.transformers) {
            localModules = transformer.call(localModules);
        }
        Injector childInjector = this.mode == LifecycleInjectorMode.REAL_CHILD_INJECTORS ? this.injector.createChildInjector(localModules) : this.createSimulatedChildInjector(localModules);
        for (PostInjectorAction action : this.actions) {
            action.call(childInjector);
        }
        return childInjector;
    }

    public Injector createInjector() {
        return this.createInjector(Lists.newArrayList());
    }

    public Injector createInjector(Module ... modules) {
        return this.createInjector(Arrays.asList(modules));
    }

    public Injector createInjector(Collection<Module> additionalModules) {
        ArrayList localModules = Lists.newArrayList();
        if (additionalModules != null) {
            localModules.addAll(additionalModules);
        }
        localModules.addAll(this.modules);
        if (!this.ignoreAllClasses) {
            HashSet localIgnoreClasses = Sets.newHashSet(this.ignoreClasses);
            localModules.add(new InternalAutoBindModule(this.injector, this.scanner, localIgnoreClasses));
        }
        return this.createChildInjector(localModules);
    }

    LifecycleInjector(LifecycleInjectorBuilderImpl builder) {
        this.scanner = builder.getClasspathScanner() != null ? builder.getClasspathScanner() : LifecycleInjector.createStandardClasspathScanner(builder.isDisableAutoBinding() ? Collections.emptyList() : builder.getBasePackages());
        AtomicReference<LifecycleManager> lifecycleManagerRef = new AtomicReference<LifecycleManager>();
        InternalBootstrapModule internalBootstrapModule = new InternalBootstrapModule((Collection<BootstrapModule>)ImmutableList.builder().addAll(builder.getBootstrapModules()).add((Object)new LoadersBootstrapModule(this.scanner)).add((Object)new InternalAutoBindModuleBootstrapModule(this.scanner, builder.getIgnoreClasses())).build(), this.scanner, builder.getStage(), builder.getLifecycleInjectorMode(), builder.getModuleListBuilder(), builder.getPostInjectorActions(), builder.getModuleTransformers(), builder.isDisableAutoBinding());
        this.injector = Guice.createInjector((Stage)builder.getStage(), (Module[])new Module[]{internalBootstrapModule, new InternalLifecycleModule(lifecycleManagerRef)});
        this.mode = (LifecycleInjectorMode)((Object)Preconditions.checkNotNull((Object)((Object)internalBootstrapModule.getMode()), (Object)"mode cannot be null"));
        this.stage = (Stage)Preconditions.checkNotNull((Object)internalBootstrapModule.getStage(), (Object)"stage cannot be null");
        this.ignoreAllClasses = internalBootstrapModule.isDisableAutoBinding();
        this.ignoreClasses = ImmutableList.copyOf(builder.getIgnoreClasses());
        this.actions = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<PostInjectorAction>>(){}));
        this.transformers = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ModuleTransformer>>(){}));
        try {
            this.modules = internalBootstrapModule.getModuleListBuilder().build(this.injector);
        }
        catch (Exception e) {
            throw new ProvisionException("Unable to resolve list of modules", (Throwable)e);
        }
        this.lifecycleManager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        lifecycleManagerRef.set(this.lifecycleManager);
    }

    private Injector createSimulatedChildInjector(Collection<Module> modules) {
        AbstractModule parentObjects = new AbstractModule(){

            protected void configure() {
                this.bindScope(LazySingleton.class, LazySingletonScope.get());
                this.bindScope(FineGrainedLazySingleton.class, FineGrainedLazySingletonScope.get());
                Map bindings = LifecycleInjector.this.injector.getAllBindings();
                for (Map.Entry binding : bindings.entrySet()) {
                    Class cls = ((Key)binding.getKey()).getTypeLiteral().getRawType();
                    if (Module.class.isAssignableFrom(cls) || Injector.class.isAssignableFrom(cls) || Stage.class.isAssignableFrom(cls) || Logger.class.isAssignableFrom(cls) || java.util.logging.Logger.class.isAssignableFrom(cls)) continue;
                    Provider provider = ((Binding)binding.getValue()).getProvider();
                    this.bind((Key)binding.getKey()).toProvider(provider);
                }
            }
        };
        AtomicReference<LifecycleManager> lifecycleManagerAtomicReference = new AtomicReference<LifecycleManager>(this.lifecycleManager);
        InternalLifecycleModule internalLifecycleModule = new InternalLifecycleModule(lifecycleManagerAtomicReference);
        ArrayList localModules = Lists.newArrayList(modules);
        localModules.add(parentObjects);
        localModules.add(internalLifecycleModule);
        return Guice.createInjector((Stage)this.stage, (Iterable)localModules);
    }
}

