/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.netflix.governator.annotations.Modules;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleListBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleListBuilder.class);
    private List<ModuleProvider> providers = Lists.newArrayList();
    private Map<Class<? extends Module>, ModuleProvider> includes = Maps.newIdentityHashMap();
    private Set<Class<? extends Module>> excludes = Sets.newIdentityHashSet();
    private List<Module> resolvedModules = Lists.newArrayList();
    private Set<Class<? extends Module>> resolvedModuleLookup = Sets.newIdentityHashSet();

    public ModuleListBuilder includeModules(Iterable<? extends Module> modules) {
        for (Module module : modules) {
            this.include(module);
        }
        return this;
    }

    public ModuleListBuilder include(Iterable<Class<? extends Module>> modules) {
        for (Class<? extends Module> module : modules) {
            this.include(module);
        }
        return this;
    }

    public ModuleListBuilder include(Module m) {
        ModuleProvider provider = new ModuleProvider(m);
        if (!m.getClass().isAnonymousClass()) {
            if (this.includes.containsKey(m.getClass())) {
                return this;
            }
            this.includes.put(m.getClass(), provider);
            for (Class dep : provider.getIncludeList()) {
                this.include(dep, false);
            }
            for (Class dep : provider.getExcludeList()) {
                this.exclude(dep);
            }
        }
        this.providers.add(provider);
        return this;
    }

    public ModuleListBuilder include(Class<? extends Module> m) {
        this.include(m, true);
        return this;
    }

    private void include(Class<? extends Module> m, boolean addToProviders) {
        ModuleProvider provider = new ModuleProvider(m);
        if (!m.getClass().isAnonymousClass()) {
            if (this.includes.containsKey(m.getClass())) {
                return;
            }
            this.includes.put(m, provider);
            for (Class dep : provider.getIncludeList()) {
                this.include(dep, false);
            }
            for (Class dep : provider.getExcludeList()) {
                this.exclude(dep);
            }
        }
        if (addToProviders) {
            this.providers.add(provider);
        }
    }

    public ModuleListBuilder exclude(Class<? extends Module> m) {
        this.excludes.add(m);
        return this;
    }

    public ModuleListBuilder exclude(Iterable<Class<? extends Module>> modules) {
        for (Class<? extends Module> module : modules) {
            this.excludes.add(module);
        }
        return this;
    }

    private void registerModule(Module m) {
        if (m.getClass().isAnonymousClass()) {
            this.resolvedModules.add(m);
        } else if (!this.resolvedModuleLookup.contains(m.getClass())) {
            LOG.info("Adding module '" + m.getClass().getName());
            this.resolvedModules.add(m);
            this.resolvedModuleLookup.add(m.getClass());
        }
    }

    List<Module> build(Injector injector) throws Exception {
        for (ModuleProvider provider : this.providers) {
            provider.getInstance(injector);
        }
        return this.resolvedModules;
    }

    public class ModuleProvider {
        Class<? extends Module> type;
        Module instance;
        boolean isExcluded = false;

        public ModuleProvider(Class<? extends Module> type) {
            this.type = type;
            this.instance = null;
        }

        public ModuleProvider(Module instance) {
            this.instance = instance;
            if (instance instanceof AbstractModule) {
                this.type = null;
            }
        }

        public void setInstance(Module module) {
            Preconditions.checkState((this.instance == null ? 1 : 0) != 0, (Object)"Instance already exists");
            this.instance = module;
        }

        public Module getInstance(Injector injector) throws Exception {
            try {
                if (this.instance != null) {
                    Module module = this.instance;
                    return module;
                }
                LOG.info("Getting instance of : " + this.type.getName());
                if (ModuleListBuilder.this.excludes.contains(this.type)) {
                    LOG.info("Module '" + this.type.getName() + "' is excluded");
                    Module module = null;
                    return module;
                }
                for (Class<? extends Module> dep : this.getIncludeList()) {
                    ModuleProvider provider = (ModuleProvider)ModuleListBuilder.this.includes.get(dep);
                    provider.getInstance(injector);
                }
                try {
                    Constructor<? extends Module> c;
                    InjectionPoint ip = InjectionPoint.forConstructorOf(this.type);
                    if (ip != null) {
                        c = (Constructor<? extends Module>)ip.getMember();
                        c.setAccessible(true);
                        List deps = ip.getDependencies();
                        if (!deps.isEmpty()) {
                            Object[] args = new Object[deps.size()];
                            for (Dependency dep : deps) {
                                Class type = dep.getKey().getTypeLiteral().getRawType();
                                if (Module.class.isAssignableFrom(type)) {
                                    args[dep.getParameterIndex()] = ((ModuleProvider)ModuleListBuilder.this.includes.get(dep.getKey().getTypeLiteral().getRawType())).getInstance(injector);
                                    continue;
                                }
                                args[dep.getParameterIndex()] = injector.getInstance(dep.getKey());
                            }
                            c.setAccessible(true);
                            this.instance = c.newInstance(args);
                        } else {
                            this.instance = c.newInstance(new Object[0]);
                        }
                    } else {
                        c = this.type.getConstructor(new Class[0]);
                        if (c != null) {
                            c.setAccessible(true);
                            this.instance = c.newInstance(new Object[0]);
                        } else {
                            this.instance = this.type.newInstance();
                        }
                    }
                    injector.injectMembers((Object)this.instance);
                    Module module = this.instance;
                    return module;
                }
                catch (Exception e) {
                    throw new ProvisionException("Failed to create module '" + this.type.getName() + "'", (Throwable)e);
                }
            }
            finally {
                if (this.instance != null) {
                    ModuleListBuilder.this.registerModule(this.instance);
                }
            }
        }

        private List<Class<? extends Module>> getIncludeList() {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.type != null) {
                Modules annot = this.type.getAnnotation(Modules.class);
                if (annot != null && annot.include() != null) {
                    builder.add((Object[])annot.include());
                }
                for (Dependency dep : InjectionPoint.forConstructorOf(this.type).getDependencies()) {
                    Class depType = dep.getKey().getTypeLiteral().getRawType();
                    if (!Module.class.isAssignableFrom(depType)) continue;
                    builder.add((Object)depType);
                }
            }
            return builder.build();
        }

        private List<Class<? extends Module>> getExcludeList() {
            Modules annot;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.type != null && (annot = this.type.getAnnotation(Modules.class)) != null && annot.exclude() != null) {
                builder.add((Object[])annot.exclude());
            }
            return builder.build();
        }
    }
}

