/*
 * Decompiled with CFR 0.152.
 */
package rx;

import rx.Observer;

public class Notification<T> {
    private final Kind kind;
    private final Throwable throwable;
    private final T value;

    public Notification(T value) {
        this.value = value;
        this.throwable = null;
        this.kind = Kind.OnNext;
    }

    public Notification(Throwable exception) {
        this.throwable = exception;
        this.value = null;
        this.kind = Kind.OnError;
    }

    public Notification() {
        this.throwable = null;
        this.value = null;
        this.kind = Kind.OnCompleted;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.isOnNext() && this.value != null;
    }

    public boolean hasThrowable() {
        return this.isOnError() && this.throwable != null;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isOnError() {
        return this.getKind() == Kind.OnError;
    }

    public boolean isOnCompleted() {
        return this.getKind() == Kind.OnCompleted;
    }

    public boolean isOnNext() {
        return this.getKind() == Kind.OnNext;
    }

    public void accept(Observer<? super T> observer) {
        if (this.isOnNext()) {
            observer.onNext(this.getValue());
        } else if (this.isOnCompleted()) {
            observer.onCompleted();
        } else if (this.isOnError()) {
            observer.onError(this.getThrowable());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[").append(super.toString()).append(" ").append((Object)this.getKind());
        if (this.hasValue()) {
            str.append(" ").append(this.getValue());
        }
        if (this.hasThrowable()) {
            str.append(" ").append(this.getThrowable().getMessage());
        }
        str.append("]");
        return str.toString();
    }

    public int hashCode() {
        int hash = this.getKind().hashCode();
        if (this.hasValue()) {
            hash = hash * 31 + this.getValue().hashCode();
        }
        if (this.hasThrowable()) {
            hash = hash * 31 + this.getThrowable().hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Notification notification = (Notification)obj;
        if (notification.getKind() != this.getKind()) {
            return false;
        }
        if (this.hasValue() && !this.getValue().equals(notification.getValue())) {
            return false;
        }
        return !this.hasThrowable() || this.getThrowable().equals(notification.getThrowable());
    }

    public static enum Kind {
        OnNext,
        OnError,
        OnCompleted;

    }
}

