/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.joins.Pattern2;
import rx.joins.Plan0;
import rx.observables.BlockingObservable;
import rx.observables.ConnectableObservable;
import rx.observables.GroupedObservable;
import rx.operators.OperationAll;
import rx.operators.OperationAmb;
import rx.operators.OperationAny;
import rx.operators.OperationAsObservable;
import rx.operators.OperationAverage;
import rx.operators.OperationBuffer;
import rx.operators.OperationCache;
import rx.operators.OperationCast;
import rx.operators.OperationCombineLatest;
import rx.operators.OperationConcat;
import rx.operators.OperationDebounce;
import rx.operators.OperationDefaultIfEmpty;
import rx.operators.OperationDefer;
import rx.operators.OperationDelay;
import rx.operators.OperationDematerialize;
import rx.operators.OperationDistinct;
import rx.operators.OperationDistinctUntilChanged;
import rx.operators.OperationDoOnEach;
import rx.operators.OperationElementAt;
import rx.operators.OperationFilter;
import rx.operators.OperationFinally;
import rx.operators.OperationFlatMap;
import rx.operators.OperationGroupBy;
import rx.operators.OperationGroupByUntil;
import rx.operators.OperationGroupJoin;
import rx.operators.OperationInterval;
import rx.operators.OperationJoin;
import rx.operators.OperationJoinPatterns;
import rx.operators.OperationMap;
import rx.operators.OperationMaterialize;
import rx.operators.OperationMerge;
import rx.operators.OperationMergeDelayError;
import rx.operators.OperationMinMax;
import rx.operators.OperationMulticast;
import rx.operators.OperationObserveOn;
import rx.operators.OperationOnErrorResumeNextViaFunction;
import rx.operators.OperationOnErrorResumeNextViaObservable;
import rx.operators.OperationOnErrorReturn;
import rx.operators.OperationOnExceptionResumeNextViaObservable;
import rx.operators.OperationParallel;
import rx.operators.OperationParallelMerge;
import rx.operators.OperationRepeat;
import rx.operators.OperationReplay;
import rx.operators.OperationRetry;
import rx.operators.OperationSample;
import rx.operators.OperationScan;
import rx.operators.OperationSequenceEqual;
import rx.operators.OperationSingle;
import rx.operators.OperationSkip;
import rx.operators.OperationSkipLast;
import rx.operators.OperationSkipUntil;
import rx.operators.OperationSkipWhile;
import rx.operators.OperationSubscribeOn;
import rx.operators.OperationSum;
import rx.operators.OperationSwitch;
import rx.operators.OperationSynchronize;
import rx.operators.OperationTake;
import rx.operators.OperationTakeLast;
import rx.operators.OperationTakeUntil;
import rx.operators.OperationTakeWhile;
import rx.operators.OperationThrottleFirst;
import rx.operators.OperationTimeInterval;
import rx.operators.OperationTimeout;
import rx.operators.OperationTimer;
import rx.operators.OperationTimestamp;
import rx.operators.OperationToMap;
import rx.operators.OperationToMultimap;
import rx.operators.OperationToObservableFuture;
import rx.operators.OperationToObservableIterable;
import rx.operators.OperationToObservableList;
import rx.operators.OperationToObservableSortedList;
import rx.operators.OperationUsing;
import rx.operators.OperationWindow;
import rx.operators.OperationZip;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.Schedulers;
import rx.subjects.AsyncSubject;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;
import rx.util.OnErrorNotImplementedException;
import rx.util.Range;
import rx.util.TimeInterval;
import rx.util.Timestamped;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Action2;
import rx.util.functions.Func0;
import rx.util.functions.Func1;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Function;
import rx.util.functions.Functions;

public class Observable<T> {
    private static final ConcurrentHashMap<Class, Boolean> internalClassMap = new ConcurrentHashMap();
    private final OnSubscribeFunc<T> onSubscribe;
    private static final RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();

    protected Observable(OnSubscribeFunc<T> onSubscribe) {
        this.onSubscribe = onSubscribe;
    }

    public Subscription subscribe(Observer<? super T> observer) {
        OnSubscribeFunc<Object> onSubscribeFunction = hook.onSubscribeStart(this, this.onSubscribe);
        if (observer == null) {
            throw new IllegalArgumentException("observer can not be null");
        }
        if (onSubscribeFunction == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        try {
            if (this.isInternalImplementation(observer)) {
                Subscription s = onSubscribeFunction.onSubscribe(observer);
                if (s == null) {
                    return hook.onSubscribeReturn(this, Subscriptions.empty());
                }
                return hook.onSubscribeReturn(this, s);
            }
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            subscription.wrap(onSubscribeFunction.onSubscribe(new SafeObserver<T>(subscription, observer)));
            return hook.onSubscribeReturn(this, subscription);
        }
        catch (OnErrorNotImplementedException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                observer.onError(hook.onSubscribeError(this, e));
            }
            catch (OnErrorNotImplementedException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                hook.onSubscribeError(this, r);
                throw r;
            }
            return Subscriptions.empty();
        }
    }

    public Subscription subscribe(Observer<? super T> observer, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(observer);
    }

    private Subscription protectivelyWrapAndSubscribe(Observer<? super T> o) {
        SafeObservableSubscription subscription = new SafeObservableSubscription();
        return subscription.wrap(this.subscribe(new SafeObserver<T>(subscription, o)));
    }

    public Subscription subscribe() {
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public void onNext(T args) {
            }
        });
    }

    public Subscription subscribe(final Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext);
    }

    public Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError);
    }

    public Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError, final Action0 onComplete) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                onComplete.call();
            }

            @Override
            public void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onComplete, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError, onComplete);
    }

    public Observable<T> asObservable() {
        return Observable.create(new OperationAsObservable(this));
    }

    public <R> ConnectableObservable<R> multicast(Subject<? super T, ? extends R> subject) {
        return OperationMulticast.multicast(this, subject);
    }

    public <TIntermediate, TResult> Observable<TResult> multicast(Func0<? extends Subject<? super T, ? extends TIntermediate>> subjectFactory, Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> selector) {
        return OperationMulticast.multicast(this, subjectFactory, selector);
    }

    public static <T> Observable<T> create(OnSubscribeFunc<T> func) {
        return new Observable<T>(func);
    }

    public static <T> Observable<T> empty() {
        return Observable.from(new ArrayList());
    }

    public static <T> Observable<T> empty(Scheduler scheduler) {
        return Observable.empty().subscribeOn(scheduler);
    }

    public static <T> Observable<T> error(Throwable exception) {
        return new ThrowObservable(exception);
    }

    public static <T> Observable<T> error(Throwable exception, Scheduler scheduler) {
        return Observable.error(exception).subscribeOn(scheduler);
    }

    public static <T> Observable<T> from(Iterable<? extends T> iterable) {
        return Observable.from(iterable, Schedulers.immediate());
    }

    public static <T> Observable<T> from(Iterable<? extends T> iterable, Scheduler scheduler) {
        return Observable.create(OperationToObservableIterable.toObservableIterable(iterable, scheduler));
    }

    public static <T> Observable<T> from(T[] items) {
        return Observable.from(Arrays.asList(items));
    }

    public static <T> Observable<T> from(T[] items, Scheduler scheduler) {
        return Observable.from(Arrays.asList(items), scheduler);
    }

    public static <T> Observable<T> from(T t1) {
        return Observable.from(Arrays.asList(t1));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2) {
        return Observable.from(Arrays.asList(t1, t2));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3) {
        return Observable.from(Arrays.asList(t1, t2, t3));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    @Deprecated
    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9, T t10) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10));
    }

    public static Observable<Integer> range(int start, int count) {
        return Observable.from(Range.createWithCount(start, count));
    }

    public static Observable<Integer> range(int start, int count, Scheduler scheduler) {
        return Observable.from(Range.createWithCount(start, count), scheduler);
    }

    public Observable<T> repeat() {
        return this.repeat(Schedulers.currentThread());
    }

    public Observable<T> repeat(Scheduler scheduler) {
        return Observable.create(OperationRepeat.repeat(this, scheduler));
    }

    public static <T> Observable<T> defer(Func0<? extends Observable<? extends T>> observableFactory) {
        return Observable.create(OperationDefer.defer(observableFactory));
    }

    @Deprecated
    public static <T> Observable<T> just(T value) {
        return Observable.from(Arrays.asList(value));
    }

    @Deprecated
    public static <T> Observable<T> just(T value, Scheduler scheduler) {
        return Observable.from(Arrays.asList(value), scheduler);
    }

    public static <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source) {
        return Observable.create(OperationMerge.merge(source));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.merge(Observable.from(t1, t2));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.merge(Observable.from(t1, t2, t3));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.merge(Observable.from(t1, t2, t3, t4));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.merge(Observable.from(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.merge(Observable.from(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.merge(Observable.from(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.merge(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.merge(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source, int maxConcurrent) {
        return Observable.create(OperationMerge.merge(source, maxConcurrent));
    }

    public static <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences) {
        return Observable.merge(Observable.from(sequences));
    }

    public static <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, int maxConcurrent) {
        return Observable.merge(Observable.from(sequences), maxConcurrent);
    }

    public static <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, int maxConcurrent, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler), maxConcurrent);
    }

    public static <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler));
    }

    public static <T> Observable<T> merge(Observable<? extends T>[] sequences) {
        return Observable.merge(Observable.from(sequences));
    }

    public static <T> Observable<T> merge(Observable<? extends T>[] sequences, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler));
    }

    public static <T> Observable<T> concat(Observable<? extends Observable<? extends T>> observables) {
        return Observable.create(OperationConcat.concat(observables));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationConcat.concat(t1, t2));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationConcat.concat(t1, t2, t3));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends Observable<? extends T>> source) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(source));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> never() {
        return new NeverObservable();
    }

    @Deprecated
    public static <T> Observable<T> switchDo(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public static <T> Observable<T> switchOnNext(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public static <T> Observable<T> switchLatest(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public Observable<T> synchronize() {
        return Observable.create(OperationSynchronize.synchronize(this));
    }

    public Observable<T> synchronize(Object lock) {
        return Observable.create(OperationSynchronize.synchronize(this, lock));
    }

    @Deprecated
    public static <T> Observable<T> synchronize(Observable<T> source) {
        return Observable.create(OperationSynchronize.synchronize(source));
    }

    public static Observable<Long> interval(long interval, TimeUnit unit) {
        return Observable.create(OperationInterval.interval(interval, unit));
    }

    public static Observable<Long> interval(long interval, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationInterval.interval(interval, unit, scheduler));
    }

    public static Observable<Long> timer(long delay, TimeUnit unit) {
        return Observable.timer(delay, unit, Schedulers.threadPoolForComputation());
    }

    public static Observable<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTimer.TimerOnce(delay, unit, scheduler));
    }

    public static Observable<Long> timer(long initialDelay, long period, TimeUnit unit) {
        return Observable.timer(initialDelay, period, unit, Schedulers.threadPoolForComputation());
    }

    public static Observable<Long> timer(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTimer.TimerPeriodically(initialDelay, period, unit, scheduler));
    }

    public <U> Observable<T> delay(Func1<? super T, ? extends Observable<U>> itemDelay) {
        return Observable.create(OperationDelay.delay(this, itemDelay));
    }

    public <U, V> Observable<T> delay(Func0<? extends Observable<U>> subscriptionDelay, Func1<? super T, ? extends Observable<V>> itemDelay) {
        return Observable.create(OperationDelay.delay(this, subscriptionDelay, itemDelay));
    }

    public Observable<T> delay(long delay, TimeUnit unit) {
        return OperationDelay.delay(this, delay, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return OperationDelay.delay(this, delay, unit, scheduler);
    }

    public Observable<T> delaySubscription(long delay, TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> delaySubscription(long delay, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDelay.delaySubscription(this, delay, unit, scheduler));
    }

    public Observable<T> debounce(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public <U> Observable<T> debounce(Func1<? super T, ? extends Observable<U>> debounceSelector) {
        return Observable.create(OperationDebounce.debounceSelector(this, debounceSelector));
    }

    public Observable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public Observable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public Observable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public Observable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, windowDuration, unit));
    }

    public Observable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, skipDuration, unit, scheduler));
    }

    public Observable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    public Observable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    public Observable<Timestamped<T>> timestamp() {
        return Observable.create(OperationTimestamp.timestamp(this));
    }

    public Observable<Timestamped<T>> timestamp(Scheduler scheduler) {
        return Observable.create(OperationTimestamp.timestamp(this, scheduler));
    }

    public static <T> Observable<T> from(Future<? extends T> future) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future));
    }

    public static <T> Observable<T> from(Future<? extends T> future, Scheduler scheduler) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future)).subscribeOn(scheduler);
    }

    public static <T> Observable<T> from(Future<? extends T> future, long timeout, TimeUnit unit) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future, timeout, unit));
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second) {
        return Observable.sequenceEqual(first, second, new Func2<T, T, Boolean>(){

            @Override
            public Boolean call(T first, T second) {
                if (first == null) {
                    return second == null;
                }
                return first.equals(second);
            }
        });
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second, Func2<? super T, ? super T, Boolean> equality) {
        return OperationSequenceEqual.sequenceEqual(first, second, equality);
    }

    public static <T1, T2, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, zipFunction));
    }

    public <T2, R> Observable<R> zip(Observable<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return Observable.zip(this, other, zipFunction);
    }

    public <T2, R> Observable<R> zip(Iterable<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zipIterable(this, other, zipFunction));
    }

    public static <T1, T2, T3, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, zipFunction));
    }

    public static <T1, T2, T3, T4, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, o8, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, o8, o9, zipFunction));
    }

    public static <T1, T2, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, combineFunction));
    }

    public static <T1, T2, T3, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, combineFunction));
    }

    public static <T1, T2, T3, T4, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, o9, combineFunction));
    }

    public <B> Observable<List<T>> buffer(Observable<B> boundary) {
        return Observable.create(OperationBuffer.bufferWithBoundaryObservable(this, boundary));
    }

    public <B> Observable<List<T>> buffer(Observable<B> boundary, int initialCapacity) {
        return Observable.create(OperationBuffer.bufferWithBoundaryObservable(this, boundary, initialCapacity));
    }

    public <TClosing> Observable<List<T>> buffer(Func0<? extends Observable<? extends TClosing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferClosingSelector));
    }

    public <TOpening, TClosing> Observable<List<T>> buffer(Observable<? extends TOpening> bufferOpenings, Func1<? super TOpening, ? extends Observable<? extends TClosing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferOpenings, bufferClosingSelector));
    }

    public Observable<List<T>> buffer(int count) {
        return Observable.create(OperationBuffer.buffer(this, count));
    }

    public Observable<List<T>> buffer(int count, int skip) {
        return Observable.create(OperationBuffer.buffer(this, count, skip));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, scheduler));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count, scheduler));
    }

    public Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit));
    }

    public Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit, scheduler));
    }

    public <TClosing> Observable<Observable<T>> window(Func0<? extends Observable<? extends TClosing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, closingSelector));
    }

    public <TOpening, TClosing> Observable<Observable<T>> window(Observable<? extends TOpening> windowOpenings, Func1<? super TOpening, ? extends Observable<? extends TClosing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, windowOpenings, closingSelector));
    }

    public <U> Observable<Observable<T>> window(Observable<U> boundary) {
        return Observable.create(OperationWindow.window(this, boundary));
    }

    public Observable<Observable<T>> window(int count) {
        return Observable.create(OperationWindow.window(this, count));
    }

    public Observable<Observable<T>> window(int count, int skip) {
        return Observable.create(OperationWindow.window(this, count, skip));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, unit));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, scheduler));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count, scheduler));
    }

    public Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit));
    }

    public Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit, scheduler));
    }

    public static <R> Observable<R> zip(Observable<? extends Observable<?>> ws, final FuncN<? extends R> zipFunction) {
        return ws.toList().mergeMap(new Func1<List<? extends Observable<?>>, Observable<? extends R>>(){

            @Override
            public Observable<R> call(List<? extends Observable<?>> wsList) {
                return Observable.create(OperationZip.zip(wsList, zipFunction));
            }
        });
    }

    public static <R> Observable<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(ws, zipFunction));
    }

    public Observable<T> filter(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationFilter.filter(this, predicate));
    }

    public Observable<T> distinctUntilChanged() {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this));
    }

    public <U> Observable<T> distinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this, keySelector));
    }

    public Observable<T> distinct() {
        return Observable.create(OperationDistinct.distinct(this));
    }

    public <U> Observable<T> distinct(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinct.distinct(this, keySelector));
    }

    public Observable<T> elementAt(int index) {
        return Observable.create(OperationElementAt.elementAt(this, index));
    }

    public Observable<T> elementAtOrDefault(int index, T defaultValue) {
        return Observable.create(OperationElementAt.elementAtOrDefault(this, index, defaultValue));
    }

    public Observable<Boolean> exists(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAny.exists(this, predicate));
    }

    public Observable<Boolean> contains(final T element) {
        return this.exists(new Func1<T, Boolean>(){

            @Override
            public Boolean call(T t1) {
                return element == null ? t1 == null : element.equals(t1);
            }
        });
    }

    public Observable<T> finallyDo(Action0 action) {
        return Observable.create(OperationFinally.finallyDo(this, action));
    }

    public <R> Observable<R> flatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return this.mergeMap(func);
    }

    public <R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(this.map(func));
    }

    public <U, R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        return Observable.create(OperationFlatMap.flatMap(this, collectionSelector, resultSelector));
    }

    public <R> Observable<R> mergeMapIterable(Func1<? super T, ? extends Iterable<? extends R>> collectionSelector) {
        return Observable.merge(this.map(OperationFlatMap.flatMapIterableFunc(collectionSelector)));
    }

    public <U, R> Observable<R> mergeMapIterable(Func1<? super T, ? extends Iterable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        return this.mergeMap(OperationFlatMap.flatMapIterableFunc(collectionSelector), resultSelector);
    }

    public <R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted) {
        return Observable.create(OperationFlatMap.flatMap(this, onNext, onError, onCompleted));
    }

    public <R> Observable<R> concatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.concat(this.map(func));
    }

    public <R> Observable<R> switchMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.switchOnNext(this.map(func));
    }

    @Deprecated
    public Observable<T> where(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate);
    }

    public <R> Observable<R> map(Func1<? super T, ? extends R> func) {
        return Observable.create(OperationMap.map(this, func));
    }

    @Deprecated
    public <R> Observable<R> mapWithIndex(Func2<? super T, Integer, ? extends R> func) {
        return Observable.create(OperationMap.mapWithIndex(this, func));
    }

    @Deprecated
    public <R> Observable<R> mapMany(Func1<? super T, ? extends Observable<? extends R>> func) {
        return this.mergeMap(func);
    }

    public Observable<Notification<T>> materialize() {
        return Observable.create(OperationMaterialize.materialize(this));
    }

    public Observable<T> subscribeOn(Scheduler scheduler) {
        return Observable.create(OperationSubscribeOn.subscribeOn(this, scheduler));
    }

    public Observable<T> observeOn(Scheduler scheduler) {
        return Observable.create(OperationObserveOn.observeOn(this, scheduler));
    }

    public <T2> Observable<T2> dematerialize() {
        return Observable.create(OperationDematerialize.dematerialize(this));
    }

    public Observable<T> onErrorResumeNext(Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return Observable.create(OperationOnErrorResumeNextViaFunction.onErrorResumeNextViaFunction(this, resumeFunction));
    }

    public Observable<T> onErrorResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnErrorResumeNextViaObservable.onErrorResumeNextViaObservable(this, resumeSequence));
    }

    public Observable<T> onExceptionResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnExceptionResumeNextViaObservable.onExceptionResumeNextViaObservable(this, resumeSequence));
    }

    public Observable<T> onErrorReturn(Func1<Throwable, ? extends T> resumeFunction) {
        return Observable.create(OperationOnErrorReturn.onErrorReturn(this, resumeFunction));
    }

    public Observable<T> reduce(Func2<T, T, T> accumulator) {
        return Observable.create(OperationScan.scan(this, accumulator)).last();
    }

    public Observable<Integer> count() {
        return this.reduce(0, new Func2<Integer, T, Integer>(){

            @Override
            public Integer call(Integer t1, T t2) {
                return t1 + 1;
            }
        });
    }

    public static Observable<Integer> sumInteger(Observable<Integer> source) {
        return OperationSum.sum(source);
    }

    @Deprecated
    public static Observable<Integer> sum(Observable<Integer> source) {
        return OperationSum.sum(source);
    }

    public static Observable<Long> sumLong(Observable<Long> source) {
        return OperationSum.sumLongs(source);
    }

    public static Observable<Float> sumFloat(Observable<Float> source) {
        return OperationSum.sumFloats(source);
    }

    public static Observable<Double> sumDouble(Observable<Double> source) {
        return OperationSum.sumDoubles(source);
    }

    public Observable<Integer> sumInteger(Func1<? super T, Integer> valueExtractor) {
        return Observable.create(new OperationSum.SumIntegerExtractor<T>(this, valueExtractor));
    }

    public Observable<Long> sumLong(Func1<? super T, Long> valueExtractor) {
        return Observable.create(new OperationSum.SumLongExtractor<T>(this, valueExtractor));
    }

    public Observable<Float> sumFloat(Func1<? super T, Float> valueExtractor) {
        return Observable.create(new OperationSum.SumFloatExtractor<T>(this, valueExtractor));
    }

    public Observable<Double> sumDouble(Func1<? super T, Double> valueExtractor) {
        return Observable.create(new OperationSum.SumDoubleExtractor<T>(this, valueExtractor));
    }

    public static Observable<Integer> averageInteger(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    @Deprecated
    public static Observable<Integer> average(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    public static Observable<Long> averageLong(Observable<Long> source) {
        return OperationAverage.averageLongs(source);
    }

    public static Observable<Float> averageFloat(Observable<Float> source) {
        return OperationAverage.averageFloats(source);
    }

    public static Observable<Double> averageDouble(Observable<Double> source) {
        return OperationAverage.averageDoubles(source);
    }

    public Observable<Integer> averageInteger(Func1<? super T, Integer> valueExtractor) {
        return Observable.create(new OperationAverage.AverageIntegerExtractor<T>(this, valueExtractor));
    }

    public Observable<Long> averageLong(Func1<? super T, Long> valueExtractor) {
        return Observable.create(new OperationAverage.AverageLongExtractor<T>(this, valueExtractor));
    }

    public Observable<Float> averageFloat(Func1<? super T, Float> valueExtractor) {
        return Observable.create(new OperationAverage.AverageFloatExtractor<T>(this, valueExtractor));
    }

    public Observable<Double> averageDouble(Func1<? super T, Double> valueExtractor) {
        return Observable.create(new OperationAverage.AverageDoubleExtractor<T>(this, valueExtractor));
    }

    public static <T extends Comparable<? super T>> Observable<T> min(Observable<T> source) {
        return OperationMinMax.min(source);
    }

    public Observable<T> min(Comparator<? super T> comparator) {
        return OperationMinMax.min(this, comparator);
    }

    public <R extends Comparable<? super R>> Observable<List<T>> minBy(Func1<T, R> selector) {
        return OperationMinMax.minBy(this, selector);
    }

    public <R> Observable<List<T>> minBy(Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.minBy(this, selector, comparator);
    }

    public static <T extends Comparable<? super T>> Observable<T> max(Observable<T> source) {
        return OperationMinMax.max(source);
    }

    public Observable<T> max(Comparator<? super T> comparator) {
        return OperationMinMax.max(this, comparator);
    }

    public <R extends Comparable<? super R>> Observable<List<T>> maxBy(Func1<T, R> selector) {
        return OperationMinMax.maxBy(this, selector);
    }

    public <R> Observable<List<T>> maxBy(Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.maxBy(this, selector, comparator);
    }

    public ConnectableObservable<T> replay() {
        return OperationMulticast.multicast(this, ReplaySubject.create());
    }

    public ConnectableObservable<T> replay(Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.createScheduledSubject(ReplaySubject.create(), scheduler));
    }

    public ConnectableObservable<T> replay(int bufferSize) {
        return OperationMulticast.multicast(this, OperationReplay.replayBuffered(bufferSize));
    }

    public ConnectableObservable<T> replay(int bufferSize, Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.createScheduledSubject(OperationReplay.replayBuffered(bufferSize), scheduler));
    }

    public ConnectableObservable<T> replay(long time, TimeUnit unit) {
        return this.replay(time, unit, Schedulers.threadPoolForComputation());
    }

    public ConnectableObservable<T> replay(long time, TimeUnit unit, Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.replayWindowed(time, unit, -1, scheduler));
    }

    public ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.threadPoolForComputation());
    }

    public ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize < 0");
        }
        return OperationMulticast.multicast(this, OperationReplay.replayWindowed(time, unit, bufferSize, scheduler));
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return ReplaySubject.create();
            }
        }, selector);
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return OperationReplay.createScheduledSubject(ReplaySubject.create(), scheduler);
            }
        }, selector);
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return OperationReplay.replayBuffered(bufferSize);
            }
        }, selector);
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return OperationReplay.createScheduledSubject(OperationReplay.replayBuffered(bufferSize), scheduler);
            }
        }, selector);
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, long time, TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.threadPoolForComputation());
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final long time, final TimeUnit unit, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return OperationReplay.replayWindowed(time, unit, -1, scheduler);
            }
        }, selector);
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, int bufferSize, long time, TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.threadPoolForComputation());
    }

    public <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize, final long time, final TimeUnit unit, final Scheduler scheduler) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize < 0");
        }
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return OperationReplay.replayWindowed(time, unit, bufferSize, scheduler);
            }
        }, selector);
    }

    public Observable<T> retry(int retryCount) {
        return Observable.create(OperationRetry.retry(this, retryCount));
    }

    public Observable<T> retry() {
        return Observable.create(OperationRetry.retry(this));
    }

    public Observable<T> cache() {
        return Observable.create(OperationCache.cache(this));
    }

    public <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f) {
        return OperationParallel.parallel(this, f);
    }

    public <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f, Scheduler s) {
        return OperationParallel.parallel(this, f, s);
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables) {
        return OperationParallelMerge.parallelMerge(source, parallelObservables);
    }

    public static <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables, Scheduler scheduler) {
        return OperationParallelMerge.parallelMerge(source, parallelObservables, scheduler);
    }

    public ConnectableObservable<T> publish() {
        return OperationMulticast.multicast(this, PublishSubject.create());
    }

    public ConnectableObservable<T> publish(T initialValue) {
        return OperationMulticast.multicast(this, BehaviorSubject.create(initialValue));
    }

    public <R> Observable<R> publish(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return PublishSubject.create();
            }
        }, selector);
    }

    public <R> Observable<R> publish(Func1<? super Observable<T>, ? extends Observable<R>> selector, final T initialValue) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return BehaviorSubject.create(initialValue);
            }
        }, selector);
    }

    public ConnectableObservable<T> publishLast() {
        return OperationMulticast.multicast(this, AsyncSubject.create());
    }

    public <R> Observable<R> publishLast(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public Subject<T, T> call() {
                return AsyncSubject.create();
            }
        }, selector);
    }

    @Deprecated
    public Observable<T> aggregate(Func2<T, T, T> accumulator) {
        return this.reduce(accumulator);
    }

    public <R> Observable<R> reduce(R initialValue, Func2<R, ? super T, R> accumulator) {
        return Observable.create(OperationScan.scan(this, initialValue, accumulator)).takeLast(1);
    }

    public <R> Observable<R> collect(R state, final Action2<R, ? super T> collector) {
        Func2 accumulator = new Func2<R, T, R>(){

            @Override
            public R call(R state, T value) {
                collector.call(state, value);
                return state;
            }
        };
        return this.reduce(state, accumulator);
    }

    @Deprecated
    public <R> Observable<R> aggregate(R initialValue, Func2<R, ? super T, R> accumulator) {
        return this.reduce(initialValue, accumulator);
    }

    public Observable<T> scan(Func2<T, T, T> accumulator) {
        return Observable.create(OperationScan.scan(this, accumulator));
    }

    public Observable<T> sample(long period, TimeUnit unit) {
        return Observable.create(OperationSample.sample(this, period, unit));
    }

    public Observable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationSample.sample(this, period, unit, scheduler));
    }

    public <U> Observable<T> sample(Observable<U> sampler) {
        return Observable.create(new OperationSample.SampleWithObservable(this, sampler));
    }

    public <R> Observable<R> scan(R initialValue, Func2<R, ? super T, R> accumulator) {
        return Observable.create(OperationScan.scan(this, initialValue, accumulator));
    }

    public Observable<Boolean> all(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAll.all(this, predicate));
    }

    public Observable<T> skip(int num) {
        return Observable.create(OperationSkip.skip(this, num));
    }

    public Observable<T> skip(long time, TimeUnit unit) {
        return this.skip(time, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> skip(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationSkip.SkipTimed(this, time, unit, scheduler));
    }

    public Observable<T> single() {
        return Observable.create(OperationSingle.single(this));
    }

    public Observable<T> single(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).single();
    }

    public Observable<T> singleOrDefault(T defaultValue) {
        return Observable.create(OperationSingle.singleOrDefault(this, defaultValue));
    }

    public Observable<T> singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).singleOrDefault(defaultValue);
    }

    public Observable<T> first() {
        return this.take(1).single();
    }

    public Observable<T> first(Func1<? super T, Boolean> predicate) {
        return this.takeFirst(predicate).single();
    }

    public Observable<T> firstOrDefault(T defaultValue) {
        return this.take(1).singleOrDefault(defaultValue);
    }

    public Observable<T> firstOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.takeFirst(predicate).singleOrDefault(defaultValue);
    }

    public Observable<T> defaultIfEmpty(T defaultValue) {
        return Observable.create(OperationDefaultIfEmpty.defaultIfEmpty(this, defaultValue));
    }

    public Observable<T> take(int num) {
        return Observable.create(OperationTake.take(this, num));
    }

    public Observable<T> take(long time, TimeUnit unit) {
        return this.take(time, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> take(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTake.TakeTimed(this, time, unit, scheduler));
    }

    public Observable<T> takeWhile(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhile(this, predicate));
    }

    public Observable<T> takeWhileWithIndex(Func2<? super T, ? super Integer, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhileWithIndex(this, predicate));
    }

    @Deprecated
    public Observable<T> takeFirst() {
        return this.take(1);
    }

    public Observable<T> takeFirst(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).take(1);
    }

    public Observable<T> takeLast(int count) {
        return Observable.create(OperationTakeLast.takeLast(this, count));
    }

    public Observable<T> takeLast(long time, TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationTakeLast.takeLast(this, time, unit, scheduler));
    }

    public Observable<T> takeLast(int count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> takeLast(int count, long time, TimeUnit unit, Scheduler scheduler) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required");
        }
        return Observable.create(OperationTakeLast.takeLast(this, count, time, unit, scheduler));
    }

    public Observable<List<T>> takeLastBuffer(int count) {
        return this.takeLast(count).toList();
    }

    public Observable<List<T>> takeLastBuffer(long time, TimeUnit unit) {
        return this.takeLast(time, unit).toList();
    }

    public Observable<List<T>> takeLastBuffer(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler).toList();
    }

    public Observable<List<T>> takeLastBuffer(int count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit).toList();
    }

    public Observable<List<T>> takeLastBuffer(int count, long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler).toList();
    }

    public <E> Observable<T> takeUntil(Observable<? extends E> other) {
        return OperationTakeUntil.takeUntil(this, other);
    }

    public Observable<T> skipWhileWithIndex(Func2<? super T, Integer, Boolean> predicate) {
        return Observable.create(OperationSkipWhile.skipWhileWithIndex(this, predicate));
    }

    public Observable<T> skipWhile(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationSkipWhile.skipWhile(this, predicate));
    }

    public Observable<T> skipLast(int count) {
        return Observable.create(OperationSkipLast.skipLast(this, count));
    }

    public Observable<T> skipLast(long time, TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.threadPoolForComputation());
    }

    public Observable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationSkipLast.SkipLastTimed(this, time, unit, scheduler));
    }

    public Observable<List<T>> toList() {
        return Observable.create(OperationToObservableList.toObservableList(this));
    }

    public Observable<List<T>> toSortedList() {
        return Observable.create(OperationToObservableSortedList.toSortedList(this));
    }

    public Observable<List<T>> toSortedList(Func2<? super T, ? super T, Integer> sortFunction) {
        return Observable.create(OperationToObservableSortedList.toSortedList(this, sortFunction));
    }

    public Observable<T> startWith(Iterable<T> values) {
        return Observable.concat(Observable.from(values), this);
    }

    public Observable<T> startWith(Iterable<T> values, Scheduler scheduler) {
        return Observable.concat(Observable.from(values, scheduler), this);
    }

    public Observable<T> startWith(T[] values, Scheduler scheduler) {
        return this.startWith((T)Arrays.asList(values), (T)scheduler);
    }

    public Observable<T> startWith(T t1) {
        return Observable.concat(Observable.from(t1), this);
    }

    public Observable<T> startWith(T t1, T t2) {
        return Observable.concat(Observable.from(t1, t2), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3) {
        return Observable.concat(Observable.from(t1, t2, t3), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4) {
        return Observable.concat(Observable.from(t1, t2, t3, t4), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8, t9), this);
    }

    public <K, R> Observable<GroupedObservable<K, R>> groupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> elementSelector) {
        return Observable.create(OperationGroupBy.groupBy(this, keySelector, elementSelector));
    }

    public <K> Observable<GroupedObservable<K, T>> groupBy(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationGroupBy.groupBy(this, keySelector));
    }

    public <T2, D1, D2, R> Observable<R> groupJoin(Observable<T2> right, Func1<? super T, ? extends Observable<D1>> leftDuration, Func1<? super T2, ? extends Observable<D2>> rightDuration, Func2<? super T, ? super Observable<T2>, ? extends R> resultSelector) {
        return Observable.create(new OperationGroupJoin(this, right, leftDuration, rightDuration, resultSelector));
    }

    public Observable<Boolean> isEmpty() {
        return Observable.create(OperationAny.isEmpty(this));
    }

    public Observable<T> last() {
        return this.takeLast(1).single();
    }

    public Observable<T> last(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).takeLast(1).single();
    }

    public Observable<T> lastOrDefault(T defaultValue) {
        return this.takeLast(1).singleOrDefault(defaultValue);
    }

    public Observable<T> lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).takeLast(1).singleOrDefault(defaultValue);
    }

    public Observable<Long> longCount() {
        return this.reduce(0L, new Func2<Long, T, Long>(){

            @Override
            public Long call(Long t1, T t2) {
                return t1 + 1L;
            }
        });
    }

    public BlockingObservable<T> toBlockingObservable() {
        return BlockingObservable.from(this);
    }

    public <R> Observable<R> cast(Class<R> klass) {
        return Observable.create(OperationCast.cast(this, klass));
    }

    public <R> Observable<R> ofType(final Class<R> klass) {
        return this.filter(new Func1<T, Boolean>(){

            @Override
            public Boolean call(T t) {
                return klass.isInstance(t);
            }
        }).cast(klass);
    }

    public Observable<T> ignoreElements() {
        return this.filter(Functions.alwaysFalse());
    }

    public Observable<T> timeout(long timeout, TimeUnit timeUnit) {
        return Observable.create(OperationTimeout.timeout(this, timeout, timeUnit));
    }

    public Observable<T> timeout(long timeout, TimeUnit timeUnit, Observable<? extends T> other) {
        return Observable.create(OperationTimeout.timeout(this, timeout, timeUnit, other));
    }

    public Observable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return Observable.create(OperationTimeout.timeout(this, timeout, timeUnit, scheduler));
    }

    public Observable<T> timeout(long timeout, TimeUnit timeUnit, Observable<? extends T> other, Scheduler scheduler) {
        return Observable.create(OperationTimeout.timeout(this, timeout, timeUnit, other, scheduler));
    }

    public <U> Observable<T> timeout(Func1<? super T, ? extends Observable<U>> timeoutSelector) {
        return this.timeout(timeoutSelector, Observable.<T>empty());
    }

    public <U> Observable<T> timeout(Func1<? super T, ? extends Observable<U>> timeoutSelector, Observable<? extends T> other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return Observable.create(OperationTimeout.timeoutSelector(this, null, timeoutSelector, other));
    }

    public <U, V> Observable<T> timeout(Func0<? extends Observable<U>> firstTimeoutSelector, Func1<? super T, ? extends Observable<U>> timeoutSelector) {
        if (firstTimeoutSelector == null) {
            throw new NullPointerException("firstTimeoutSelector");
        }
        return this.timeout(firstTimeoutSelector, timeoutSelector, Observable.<T>empty());
    }

    public <U, V> Observable<T> timeout(Func0<? extends Observable<U>> firstTimeoutSelector, Func1<? super T, ? extends Observable<U>> timeoutSelector, Observable<? extends T> other) {
        if (firstTimeoutSelector == null) {
            throw new NullPointerException("firstTimeoutSelector");
        }
        if (other == null) {
            throw new NullPointerException("other");
        }
        return Observable.create(OperationTimeout.timeoutSelector(this, firstTimeoutSelector, timeoutSelector, other));
    }

    public Observable<TimeInterval<T>> timeInterval() {
        return Observable.create(OperationTimeInterval.timeInterval(this));
    }

    public Observable<TimeInterval<T>> timeInterval(Scheduler scheduler) {
        return Observable.create(OperationTimeInterval.timeInterval(this, scheduler));
    }

    public static <T, RESOURCE extends Subscription> Observable<T> using(Func0<RESOURCE> resourceFactory, Func1<RESOURCE, Observable<T>> observableFactory) {
        return Observable.create(OperationUsing.using(resourceFactory, observableFactory));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2) {
        return Observable.create(OperationAmb.amb(o1, o2));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3) {
        return Observable.create(OperationAmb.amb(o1, o2, o3));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4, o5));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4, o5, o6));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4, o5, o6, o7));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7, Observable<? extends T> o8) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4, o5, o6, o7, o8));
    }

    public static <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7, Observable<? extends T> o8, Observable<? extends T> o9) {
        return Observable.create(OperationAmb.amb(o1, o2, o3, o4, o5, o6, o7, o8, o9));
    }

    public static <T> Observable<T> amb(Iterable<? extends Observable<? extends T>> sources) {
        return Observable.create(OperationAmb.amb(sources));
    }

    public Observable<T> doOnEach(Observer<? super T> observer) {
        return Observable.create(OperationDoOnEach.doOnEach(this, observer));
    }

    public Observable<T> doOnError(final Action1<Throwable> onError) {
        Observer observer = new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public void onNext(T args) {
            }
        };
        return Observable.create(OperationDoOnEach.doOnEach(this, observer));
    }

    public Observable<T> doOnCompleted(final Action0 onCompleted) {
        Observer observer = new Observer<T>(){

            @Override
            public void onCompleted() {
                onCompleted.call();
            }

            @Override
            public void onError(Throwable e) {
            }

            @Override
            public void onNext(T args) {
            }
        };
        return Observable.create(OperationDoOnEach.doOnEach(this, observer));
    }

    public Observable<T> doOnNext(final Action1<? super T> onNext) {
        Observer observer = new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        };
        return Observable.create(OperationDoOnEach.doOnEach(this, observer));
    }

    public Observable<T> doOnEach(final Action1<Notification<? super T>> onNotification) {
        Observer observer = new Observer<T>(){

            @Override
            public void onCompleted() {
                onNotification.call(new Notification());
            }

            @Override
            public void onError(Throwable e) {
                onNotification.call(new Notification(e));
            }

            @Override
            public void onNext(T v) {
                onNotification.call(new Notification(v));
            }
        };
        return Observable.create(OperationDoOnEach.doOnEach(this, observer));
    }

    private boolean isInternalImplementation(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof SafeObserver) {
            return true;
        }
        Class<?> clazz = o.getClass();
        if (internalClassMap.containsKey(clazz)) {
            return internalClassMap.get(clazz);
        }
        Package p = o.getClass().getPackage();
        Boolean isInternal = p != null && p.getName().startsWith("rx.operators");
        internalClassMap.put(clazz, isInternal);
        return isInternal;
    }

    public <T2> Pattern2<T, T2> and(Observable<T2> right) {
        return OperationJoinPatterns.and(this, right);
    }

    public <R> Plan0<R> then(Func1<T, R> selector) {
        return OperationJoinPatterns.then(this, selector);
    }

    public static <R> Observable<R> when(Plan0<R> ... plans) {
        return Observable.create(OperationJoinPatterns.when(plans));
    }

    public static <R> Observable<R> when(Iterable<? extends Plan0<R>> plans) {
        if (plans == null) {
            throw new NullPointerException("plans");
        }
        return Observable.create(OperationJoinPatterns.when(plans));
    }

    public static <R> Observable<R> when(Plan0<R> p1) {
        return Observable.create(OperationJoinPatterns.when(p1));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2) {
        return Observable.create(OperationJoinPatterns.when(p1, p2));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7, Plan0<R> p8) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7, p8));
    }

    public static <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7, Plan0<R> p8, Plan0<R> p9) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7, p8, p9));
    }

    public <TRight, TLeftDuration, TRightDuration, R> Observable<R> join(Observable<TRight> right, Func1<T, Observable<TLeftDuration>> leftDurationSelector, Func1<TRight, Observable<TRightDuration>> rightDurationSelector, Func2<T, TRight, R> resultSelector) {
        return Observable.create(new OperationJoin<T, TRight, TLeftDuration, TRightDuration, R>(this, right, leftDurationSelector, rightDurationSelector, resultSelector));
    }

    public <K> Observable<Map<K, T>> toMap(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationToMap.toMap(this, keySelector));
    }

    public <K, V> Observable<Map<K, V>> toMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return Observable.create(OperationToMap.toMap(this, keySelector, valueSelector));
    }

    public <K, V> Observable<Map<K, V>> toMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        return Observable.create(OperationToMap.toMap(this, keySelector, valueSelector, mapFactory));
    }

    public <K> Observable<Map<K, Collection<T>>> toMultimap(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector));
    }

    public <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector));
    }

    public <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector, mapFactory));
    }

    public <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory, Func1<? super K, ? extends Collection<V>> collectionFactory) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector, mapFactory, collectionFactory));
    }

    public <U> Observable<T> skipUntil(Observable<U> other) {
        return Observable.create(new OperationSkipUntil(this, other));
    }

    public <TKey, TDuration> Observable<GroupedObservable<TKey, T>> groupByUntil(Func1<? super T, ? extends TKey> keySelector, Func1<? super GroupedObservable<TKey, T>, ? extends Observable<? extends TDuration>> durationSelector) {
        return this.groupByUntil(keySelector, Functions.identity(), durationSelector);
    }

    public <TKey, TValue, TDuration> Observable<GroupedObservable<TKey, TValue>> groupByUntil(Func1<? super T, ? extends TKey> keySelector, Func1<? super T, ? extends TValue> valueSelector, Func1<? super GroupedObservable<TKey, TValue>, ? extends Observable<? extends TDuration>> durationSelector) {
        return Observable.create(new OperationGroupByUntil(this, keySelector, valueSelector, durationSelector));
    }

    private static class ThrowObservable<T>
    extends Observable<T> {
        public ThrowObservable(final Throwable exception) {
            super(new OnSubscribeFunc<T>(){

                @Override
                public Subscription onSubscribe(Observer<? super T> observer) {
                    observer.onError(exception);
                    return Subscriptions.empty();
                }
            });
        }
    }

    private static class NeverObservable<T>
    extends Observable<T> {
        public NeverObservable() {
            super(new OnSubscribeFunc<T>(){

                @Override
                public Subscription onSubscribe(Observer<? super T> t1) {
                    return Subscriptions.empty();
                }
            });
        }
    }

    public static interface OnSubscribeFunc<T>
    extends Function {
        public Subscription onSubscribe(Observer<? super T> var1);
    }
}

