/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Func2;

public abstract class Scheduler {
    public abstract <T> Subscription schedule(T var1, Func2<? super Scheduler, ? super T, ? extends Subscription> var2);

    public abstract <T> Subscription schedule(T var1, Func2<? super Scheduler, ? super T, ? extends Subscription> var2, long var3, TimeUnit var5);

    public <T> Subscription schedulePeriodically(T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        final long periodInNanos = unit.toNanos(period);
        final AtomicBoolean complete = new AtomicBoolean();
        Func2 recursiveAction = new Func2<Scheduler, T, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, T state0) {
                if (!complete.get()) {
                    long startedAt = Scheduler.this.now();
                    final Subscription sub1 = (Subscription)action.call(scheduler, state0);
                    long timeTakenByActionInNanos = TimeUnit.MILLISECONDS.toNanos(Scheduler.this.now() - startedAt);
                    final Subscription sub2 = Scheduler.this.schedule(state0, this, periodInNanos - timeTakenByActionInNanos, TimeUnit.NANOSECONDS);
                    return Subscriptions.create(new Action0(){

                        @Override
                        public void call() {
                            sub1.unsubscribe();
                            sub2.unsubscribe();
                        }
                    });
                }
                return Subscriptions.empty();
            }
        };
        final Subscription sub = this.schedule(state, recursiveAction, initialDelay, unit);
        return Subscriptions.create(new Action0(){

            @Override
            public void call() {
                complete.set(true);
                sub.unsubscribe();
            }
        });
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, Date dueTime) {
        long scheduledTime = dueTime.getTime();
        long timeInFuture = scheduledTime - this.now();
        if (timeInFuture <= 0L) {
            return this.schedule(state, action);
        }
        return this.schedule(state, action, timeInFuture, TimeUnit.MILLISECONDS);
    }

    public Subscription schedule(final Action1<Action0> action) {
        final CompositeSubscription parentSubscription = new CompositeSubscription(new Subscription[0]);
        final MultipleAssignmentSubscription childSubscription = new MultipleAssignmentSubscription();
        parentSubscription.add(childSubscription);
        Func2<Scheduler, Func2, Subscription> parentAction = new Func2<Scheduler, Func2, Subscription>(){

            @Override
            public Subscription call(final Scheduler scheduler, final Func2 parentAction) {
                action.call(new Action0(){

                    @Override
                    public void call() {
                        if (!parentSubscription.isUnsubscribed()) {
                            childSubscription.set(scheduler.schedule(parentAction, parentAction));
                        }
                    }
                });
                return childSubscription;
            }
        };
        parentSubscription.add(this.schedule(parentAction, parentAction));
        return parentSubscription;
    }

    public Subscription schedule(final Action0 action) {
        return this.schedule(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        });
    }

    public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
        return this.schedule(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        }, delayTime, unit);
    }

    public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
        return this.schedulePeriodically(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        }, initialDelay, period, unit);
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public int degreeOfParallelism() {
        return Runtime.getRuntime().availableProcessors();
    }
}

