/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import rx.Notification;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver1;
import rx.util.functions.Action0;
import rx.util.functions.Action2;

public class ActivePlan2<T1, T2>
extends ActivePlan0 {
    private final Action2<T1, T2> onNext;
    private final Action0 onCompleted;
    private final JoinObserver1<T1> first;
    private final JoinObserver1<T2> second;

    public ActivePlan2(JoinObserver1<T1> first, JoinObserver1<T2> second, Action2<T1, T2> onNext, Action0 onCompleted) {
        this.onNext = onNext;
        this.onCompleted = onCompleted;
        this.first = first;
        this.second = second;
        this.addJoinObserver(first);
        this.addJoinObserver(second);
    }

    @Override
    public void match() {
        if (!this.first.queue().isEmpty() && !this.second.queue().isEmpty()) {
            Notification<T1> n1 = this.first.queue().peek();
            Notification<T2> n2 = this.second.queue().peek();
            if (n1.isOnCompleted() || n2.isOnCompleted()) {
                this.onCompleted.call();
            } else {
                this.dequeue();
                this.onNext.call(n1.getValue(), n2.getValue());
            }
        }
    }
}

