/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import rx.Notification;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver1;
import rx.util.functions.Action0;
import rx.util.functions.Action3;

public class ActivePlan3<T1, T2, T3>
extends ActivePlan0 {
    private final Action3<T1, T2, T3> onNext;
    private final Action0 onCompleted;
    private final JoinObserver1<T1> first;
    private final JoinObserver1<T2> second;
    private final JoinObserver1<T3> third;

    public ActivePlan3(JoinObserver1<T1> first, JoinObserver1<T2> second, JoinObserver1<T3> third, Action3<T1, T2, T3> onNext, Action0 onCompleted) {
        this.onNext = onNext;
        this.onCompleted = onCompleted;
        this.first = first;
        this.second = second;
        this.third = third;
        this.addJoinObserver(first);
        this.addJoinObserver(second);
        this.addJoinObserver(third);
    }

    @Override
    public void match() {
        if (!(this.first.queue().isEmpty() || this.second.queue().isEmpty() || this.third.queue().isEmpty())) {
            Notification<T1> n1 = this.first.queue().peek();
            Notification<T2> n2 = this.second.queue().peek();
            Notification<T3> n3 = this.third.queue().peek();
            if (n1.isOnCompleted() || n2.isOnCompleted() || n3.isOnCompleted()) {
                this.onCompleted.call();
            } else {
                this.dequeue();
                this.onNext.call(n1.getValue(), n2.getValue(), n3.getValue());
            }
        }
    }
}

