/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.util.functions.Action1;

public final class JoinObserver1<T>
implements Observer<Notification<T>>,
JoinObserver {
    private Object gate;
    private final Observable<T> source;
    private final Action1<Throwable> onError;
    private final List<ActivePlan0> activePlans;
    private final Queue<Notification<T>> queue;
    private final SafeObservableSubscription subscription = new SafeObservableSubscription();
    private volatile boolean done;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private final SafeObserver<Notification<T>> safeObserver;

    public JoinObserver1(Observable<T> source, Action1<Throwable> onError) {
        this.source = source;
        this.onError = onError;
        this.queue = new LinkedList<Notification<T>>();
        this.activePlans = new ArrayList<ActivePlan0>();
        this.safeObserver = new SafeObserver(this.subscription, new InnerObserver());
    }

    public Queue<Notification<T>> queue() {
        return this.queue;
    }

    public void addActivePlan(ActivePlan0 activePlan) {
        this.activePlans.add(activePlan);
    }

    @Override
    public void subscribe(Object gate) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Can only be subscribed to once.");
        }
        this.gate = gate;
        this.subscription.wrap(this.source.materialize().subscribe(this));
    }

    @Override
    public void dequeue() {
        this.queue.remove();
    }

    @Override
    public void onNext(Notification<T> args) {
        this.safeObserver.onNext(args);
    }

    @Override
    public void onError(Throwable e) {
        this.safeObserver.onError(e);
    }

    @Override
    public void onCompleted() {
        this.safeObserver.onCompleted();
    }

    void removeActivePlan(ActivePlan0 activePlan) {
        this.activePlans.remove(activePlan);
        if (this.activePlans.isEmpty()) {
            this.unsubscribe();
        }
    }

    @Override
    public void unsubscribe() {
        if (!this.done) {
            this.done = true;
            this.subscription.unsubscribe();
        }
    }

    private final class InnerObserver
    implements Observer<Notification<T>> {
        private InnerObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Notification<T> args) {
            Object object = JoinObserver1.this.gate;
            synchronized (object) {
                if (!JoinObserver1.this.done) {
                    if (args.isOnError()) {
                        JoinObserver1.this.onError.call(args.getThrowable());
                        return;
                    }
                    JoinObserver1.this.queue.add(args);
                    for (ActivePlan0 a : new ArrayList(JoinObserver1.this.activePlans)) {
                        a.match();
                    }
                }
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onCompleted() {
        }
    }
}

