/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observer;
import rx.joins.ActivePlan0;
import rx.joins.ActivePlan2;
import rx.joins.JoinObserver;
import rx.joins.JoinObserver1;
import rx.joins.Pattern2;
import rx.joins.Plan0;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Action2;
import rx.util.functions.Actions;
import rx.util.functions.Func2;

public class Plan2<T1, T2, R>
extends Plan0<R> {
    protected Pattern2<T1, T2> expression;
    protected Func2<T1, T2, R> selector;

    public Plan2(Pattern2<T1, T2> expression, Func2<T1, T2, R> selector) {
        this.expression = expression;
        this.selector = selector;
    }

    @Override
    public ActivePlan0 activate(Map<Object, JoinObserver> externalSubscriptions, final Observer<R> observer, final Action1<ActivePlan0> deactivate) {
        Action1<Throwable> onError = Actions.onErrorFrom(observer);
        final JoinObserver1<T1> firstJoinObserver = Plan2.createObserver(externalSubscriptions, this.expression.first(), onError);
        final JoinObserver1<T2> secondJoinObserver = Plan2.createObserver(externalSubscriptions, this.expression.second(), onError);
        final AtomicReference<ActivePlan2<T1, T2>> self = new AtomicReference<ActivePlan2<T1, T2>>();
        ActivePlan2<T1, T2> activePlan = new ActivePlan2<T1, T2>(firstJoinObserver, secondJoinObserver, new Action2<T1, T2>(){

            @Override
            public void call(T1 t1, T2 t2) {
                Object result;
                try {
                    result = Plan2.this.selector.call(t1, t2);
                }
                catch (Throwable t) {
                    observer.onError(t);
                    return;
                }
                observer.onNext(result);
            }
        }, new Action0(){

            @Override
            public void call() {
                firstJoinObserver.removeActivePlan((ActivePlan0)self.get());
                secondJoinObserver.removeActivePlan((ActivePlan0)self.get());
                deactivate.call(self.get());
            }
        });
        self.set(activePlan);
        firstJoinObserver.addActivePlan(activePlan);
        secondJoinObserver.addActivePlan(activePlan);
        return activePlan;
    }
}

