/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observer;
import rx.joins.ActivePlan0;
import rx.joins.ActivePlan3;
import rx.joins.JoinObserver;
import rx.joins.JoinObserver1;
import rx.joins.Pattern3;
import rx.joins.Plan0;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Action3;
import rx.util.functions.Actions;
import rx.util.functions.Func3;

public class Plan3<T1, T2, T3, R>
extends Plan0<R> {
    protected Pattern3<T1, T2, T3> expression;
    protected Func3<T1, T2, T3, R> selector;

    public Plan3(Pattern3<T1, T2, T3> expression, Func3<T1, T2, T3, R> selector) {
        this.expression = expression;
        this.selector = selector;
    }

    @Override
    public ActivePlan0 activate(Map<Object, JoinObserver> externalSubscriptions, final Observer<R> observer, final Action1<ActivePlan0> deactivate) {
        Action1<Throwable> onError = Actions.onErrorFrom(observer);
        final JoinObserver1<T1> firstJoinObserver = Plan3.createObserver(externalSubscriptions, this.expression.first(), onError);
        final JoinObserver1<T2> secondJoinObserver = Plan3.createObserver(externalSubscriptions, this.expression.second(), onError);
        final JoinObserver1<T3> thirdJoinObserver = Plan3.createObserver(externalSubscriptions, this.expression.third(), onError);
        final AtomicReference<ActivePlan3<T1, T2, T3>> self = new AtomicReference<ActivePlan3<T1, T2, T3>>();
        ActivePlan3<T1, T2, T3> activePlan = new ActivePlan3<T1, T2, T3>(firstJoinObserver, secondJoinObserver, thirdJoinObserver, new Action3<T1, T2, T3>(){

            @Override
            public void call(T1 t1, T2 t2, T3 t3) {
                Object result;
                try {
                    result = Plan3.this.selector.call(t1, t2, t3);
                }
                catch (Throwable t) {
                    observer.onError(t);
                    return;
                }
                observer.onNext(result);
            }
        }, new Action0(){

            @Override
            public void call() {
                firstJoinObserver.removeActivePlan((ActivePlan0)self.get());
                secondJoinObserver.removeActivePlan((ActivePlan0)self.get());
                thirdJoinObserver.removeActivePlan((ActivePlan0)self.get());
                deactivate.call(self.get());
            }
        });
        self.set(activePlan);
        firstJoinObserver.addActivePlan(activePlan);
        secondJoinObserver.addActivePlan(activePlan);
        thirdJoinObserver.addActivePlan(activePlan);
        return activePlan;
    }
}

