/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public final class OperationConcat {
    public static <T> Observable.OnSubscribeFunc<T> concat(Observable<? extends T> ... sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(Iterable<? extends Observable<? extends T>> sequences) {
        return OperationConcat.concat(Observable.from(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> concat(final Observable<? extends Observable<? extends T>> sequences) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> t1) {
                return new Concat(sequences).onSubscribe(t1);
            }
        };
    }

    private static class Concat<T>
    implements Observable.OnSubscribeFunc<T> {
        private Observable<? extends Observable<? extends T>> sequences;
        private SafeObservableSubscription innerSubscription = null;

        public Concat(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicBoolean completedOrErred = new AtomicBoolean(false);
            final AtomicBoolean allSequencesReceived = new AtomicBoolean(false);
            final ConcurrentLinkedQueue nextSequences = new ConcurrentLinkedQueue();
            final SafeObservableSubscription outerSubscription = new SafeObservableSubscription();
            final Observer reusableObserver = new Observer<T>(){

                @Override
                public void onNext(T item) {
                    observer.onNext(item);
                }

                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        outerSubscription.unsubscribe();
                        observer.onError(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (nextSequences.isEmpty()) {
                            Concat.this.innerSubscription = null;
                            if (allSequencesReceived.get() && completedOrErred.compareAndSet(false, true)) {
                                observer.onCompleted();
                            }
                        } else {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(((Observable)nextSequences.poll()).subscribe(this));
                        }
                    }
                }
            };
            outerSubscription.wrap(this.sequences.subscribe(new Observer<Observable<? extends T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(Observable<? extends T> nextSequence) {
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        if (Concat.this.innerSubscription == null) {
                            Concat.this.innerSubscription = new SafeObservableSubscription();
                            Concat.this.innerSubscription.wrap(nextSequence.subscribe(reusableObserver));
                        } else {
                            nextSequences.add(nextSequence);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable e) {
                    if (completedOrErred.compareAndSet(false, true)) {
                        SafeObservableSubscription q;
                        Queue queue = nextSequences;
                        synchronized (queue) {
                            q = Concat.this.innerSubscription;
                        }
                        if (q != null) {
                            q.unsubscribe();
                        }
                        observer.onError(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    SafeObservableSubscription q;
                    allSequencesReceived.set(true);
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        q = Concat.this.innerSubscription;
                    }
                    if (q == null && completedOrErred.compareAndSet(false, true)) {
                        observer.onCompleted();
                    }
                }
            }));
            return new Subscription(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void unsubscribe() {
                    SafeObservableSubscription q;
                    Queue queue = nextSequences;
                    synchronized (queue) {
                        q = Concat.this.innerSubscription;
                    }
                    if (q != null) {
                        q.unsubscribe();
                    }
                    outerSubscription.unsubscribe();
                }
            };
        }
    }
}

