/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.SynchronizedObserver;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.util.functions.Action0;
import rx.util.functions.Func1;

public final class OperationDebounce {
    public static <T> Observable.OnSubscribeFunc<T> debounce(Observable<T> items, long timeout, TimeUnit unit) {
        return OperationDebounce.debounce(items, timeout, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> debounce(final Observable<T> items, final long timeout, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Debounce(items, timeout, unit, scheduler).onSubscribe(observer);
            }
        };
    }

    public static <T, U> Observable.OnSubscribeFunc<T> debounceSelector(Observable<? extends T> source, Func1<? super T, ? extends Observable<U>> debounceSelector) {
        return new DebounceSelector(source, debounceSelector);
    }

    private static final class DebounceSelector<T, U>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final Func1<? super T, ? extends Observable<U>> debounceSelector;

        public DebounceSelector(Observable<? extends T> source, Func1<? super T, ? extends Observable<U>> debounceSelector) {
            this.source = source;
            this.debounceSelector = debounceSelector;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            CompositeSubscription csub = new CompositeSubscription(new Subscription[0]);
            csub.add(this.source.subscribe(new SourceObserver(t1, this.debounceSelector, csub)));
            return csub;
        }

        private static final class DebounceObserver<T, U>
        implements Observer<U> {
            final SourceObserver<T, U> parent;
            final Subscription cancel;
            final T value;
            final long currentIndex;

            public DebounceObserver(SourceObserver<T, U> parent, Subscription cancel, T value, long currentIndex) {
                this.parent = parent;
                this.cancel = cancel;
                this.value = value;
                this.currentIndex = currentIndex;
            }

            @Override
            public void onNext(U args) {
                this.onCompleted();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.parent.guard;
                synchronized (object) {
                    this.parent.observer.onError(e);
                }
                this.parent.cancel.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = this.parent.guard;
                synchronized (object) {
                    if (this.parent.hasValue && this.parent.index == this.currentIndex) {
                        this.parent.observer.onNext(this.value);
                    }
                    this.parent.hasValue = false;
                }
                this.cancel.unsubscribe();
            }
        }

        private static final class SourceObserver<T, U>
        implements Observer<T> {
            final Observer<? super T> observer;
            final Func1<? super T, ? extends Observable<U>> debounceSelector;
            final CompositeSubscription cancel;
            final SerialSubscription ssub = new SerialSubscription();
            long index;
            T value;
            boolean hasValue;
            final Object guard;

            public SourceObserver(Observer<? super T> observer, Func1<? super T, ? extends Observable<U>> debounceSelector, CompositeSubscription cancel) {
                this.observer = observer;
                this.debounceSelector = debounceSelector;
                this.cancel = cancel;
                this.cancel.add(this.ssub);
                this.guard = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                long currentIndex;
                Observable<U> o;
                try {
                    o = this.debounceSelector.call(args);
                }
                catch (Throwable t) {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onError(t);
                    }
                    this.cancel.unsubscribe();
                    return;
                }
                Object object = this.guard;
                synchronized (object) {
                    this.hasValue = true;
                    this.value = args;
                    currentIndex = ++this.index;
                }
                SerialSubscription osub = new SerialSubscription();
                this.ssub.set(osub);
                osub.set(o.subscribe(new DebounceObserver(this, osub, args, currentIndex)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                this.ssub.unsubscribe();
                try {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onError(e);
                        this.hasValue = false;
                        this.value = null;
                        ++this.index;
                    }
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                this.ssub.unsubscribe();
                try {
                    Object object = this.guard;
                    synchronized (object) {
                        block10: {
                            if (!this.hasValue) break block10;
                            try {
                                this.observer.onNext(this.value);
                            }
                            catch (Throwable t) {
                                this.observer.onError(t);
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                                this.cancel.unsubscribe();
                                return;
                            }
                        }
                        this.observer.onCompleted();
                        this.hasValue = false;
                        this.value = null;
                        ++this.index;
                    }
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }
        }
    }

    private static class DebounceObserver<T>
    implements Observer<T> {
        private final Observer<? super T> observer;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicReference<Subscription> lastScheduledNotification = new AtomicReference();

        public DebounceObserver(Observer<? super T> observer, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.observer = new SynchronizedObserver<T>(observer);
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onCompleted() {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onError(e);
        }

        @Override
        public void onNext(final T v) {
            Subscription previousSubscription = this.lastScheduledNotification.getAndSet(this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    DebounceObserver.this.observer.onNext(v);
                }
            }, this.timeout, this.unit));
            if (previousSubscription != null) {
                previousSubscription.unsubscribe();
            }
        }
    }

    private static class Debounce<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<T> items;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;

        public Debounce(Observable<T> items, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.items = items;
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new DebounceObserver<T>(observer, this.timeout, this.unit, this.scheduler));
        }
    }
}

