/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.util.functions.Func0;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationFlatMap {
    private OperationFlatMap() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, U, R> Observable.OnSubscribeFunc<R> flatMap(Observable<? extends T> source, Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        return new FlatMapPairSelector<T, U, R>(source, collectionSelector, resultSelector);
    }

    public static <T, U> Func1<T, Observable<U>> flatMapIterableFunc(Func1<? super T, ? extends Iterable<? extends U>> collectionSelector) {
        return new IterableToObservableFunc(collectionSelector);
    }

    public static <T, R> Observable.OnSubscribeFunc<R> flatMap(Observable<? extends T> source, Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted) {
        return new FlatMapTransform(source, onNext, onError, onCompleted);
    }

    private static final class FlatMapTransform<T, R>
    implements Observable.OnSubscribeFunc<R> {
        final Observable<? extends T> source;
        final Func1<? super T, ? extends Observable<? extends R>> onNext;
        final Func1<? super Throwable, ? extends Observable<? extends R>> onError;
        final Func0<? extends Observable<? extends R>> onCompleted;

        public FlatMapTransform(Observable<? extends T> source, Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted) {
            this.source = source;
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            CompositeSubscription csub = new CompositeSubscription(new Subscription[0]);
            csub.add(this.source.subscribe(new SourceObserver<T, R>(t1, this.onNext, this.onError, this.onCompleted, csub)));
            return csub;
        }

        private static final class CollectionObserver<T, R>
        implements Observer<R> {
            final SourceObserver<T, R> parent;
            final Subscription cancel;

            public CollectionObserver(SourceObserver<T, R> parent, Subscription cancel) {
                this.parent = parent;
                this.cancel = cancel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(R args) {
                Object object = this.parent.guard;
                synchronized (object) {
                    this.parent.observer.onNext(args);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.parent.guard;
                synchronized (object) {
                    this.parent.observer.onError(e);
                }
                this.parent.csub.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.parent.csub.remove(this.cancel);
                this.parent.finish();
            }
        }

        private static final class SourceObserver<T, R>
        implements Observer<T> {
            final Observer<? super R> observer;
            final Func1<? super T, ? extends Observable<? extends R>> onNext;
            final Func1<? super Throwable, ? extends Observable<? extends R>> onError;
            final Func0<? extends Observable<? extends R>> onCompleted;
            final CompositeSubscription csub;
            final AtomicInteger wip;
            volatile boolean done;
            final Object guard;

            public SourceObserver(Observer<? super R> observer, Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted, CompositeSubscription csub) {
                this.observer = observer;
                this.onNext = onNext;
                this.onError = onError;
                this.onCompleted = onCompleted;
                this.csub = csub;
                this.guard = new Object();
                this.wip = new AtomicInteger(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                Observable<? extends R> o;
                try {
                    o = this.onNext.call(args);
                }
                catch (Throwable t) {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onError(t);
                    }
                    this.csub.unsubscribe();
                    return;
                }
                this.subscribeInner(o);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Observable<? extends R> o;
                try {
                    o = this.onError.call(e);
                }
                catch (Throwable t) {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onError(t);
                    }
                    this.csub.unsubscribe();
                    return;
                }
                this.subscribeInner(o);
                this.done = true;
                this.finish();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Observable<? extends R> o;
                try {
                    o = this.onCompleted.call();
                }
                catch (Throwable t) {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onError(t);
                    }
                    this.csub.unsubscribe();
                    return;
                }
                this.subscribeInner(o);
                this.done = true;
                this.finish();
            }

            void subscribeInner(Observable<? extends R> o) {
                SerialSubscription ssub = new SerialSubscription();
                this.wip.incrementAndGet();
                this.csub.add(ssub);
                ssub.set(o.subscribe(new CollectionObserver(this, ssub)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void finish() {
                if (this.wip.decrementAndGet() == 0) {
                    Object object = this.guard;
                    synchronized (object) {
                        this.observer.onCompleted();
                    }
                    this.csub.unsubscribe();
                }
            }
        }
    }

    private static final class FlatMapPairSelector<T, U, R>
    implements Observable.OnSubscribeFunc<R> {
        final Observable<? extends T> source;
        final Func1<? super T, ? extends Observable<? extends U>> collectionSelector;
        final Func2<? super T, ? super U, ? extends R> resultSelector;

        public FlatMapPairSelector(Observable<? extends T> source, Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
            this.source = source;
            this.collectionSelector = collectionSelector;
            this.resultSelector = resultSelector;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            CompositeSubscription csub = new CompositeSubscription(new Subscription[0]);
            csub.add(this.source.subscribe(new SourceObserver<T, U, R>(t1, this.collectionSelector, this.resultSelector, csub)));
            return csub;
        }

        private static final class CollectionObserver<T, U, R>
        implements Observer<U> {
            final SourceObserver<T, U, R> so;
            final Subscription cancel;
            final T value;

            public CollectionObserver(SourceObserver<T, U, R> so, T value, Subscription cancel) {
                this.so = so;
                this.value = value;
                this.cancel = cancel;
            }

            @Override
            public void onNext(U args) {
                this.so.emit(this.value, args);
            }

            @Override
            public void onError(Throwable e) {
                this.so.onError(e);
            }

            @Override
            public void onCompleted() {
                this.so.complete(this.cancel);
            }
        }

        private static final class SourceObserver<T, U, R>
        implements Observer<T> {
            final Observer<? super R> observer;
            final Func1<? super T, ? extends Observable<? extends U>> collectionSelector;
            final Func2<? super T, ? super U, ? extends R> resultSelector;
            final CompositeSubscription csub;
            final AtomicInteger wip;
            final Object guard;
            boolean done;

            public SourceObserver(Observer<? super R> observer, Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector, CompositeSubscription csub) {
                this.observer = observer;
                this.collectionSelector = collectionSelector;
                this.resultSelector = resultSelector;
                this.csub = csub;
                this.wip = new AtomicInteger(1);
                this.guard = new Object();
            }

            @Override
            public void onNext(T args) {
                Observable<U> coll;
                try {
                    coll = this.collectionSelector.call(args);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                SerialSubscription ssub = new SerialSubscription();
                this.csub.add(ssub);
                this.wip.incrementAndGet();
                ssub.set(coll.subscribe(new CollectionObserver(this, args, ssub)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.guard;
                synchronized (object) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    this.observer.onError(e);
                }
                this.csub.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (this.wip.decrementAndGet() == 0) {
                    Object object = this.guard;
                    synchronized (object) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                        this.observer.onCompleted();
                    }
                    this.csub.unsubscribe();
                }
            }

            void complete(Subscription s) {
                this.csub.remove(s);
                this.onCompleted();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void emit(T t, U u) {
                R r;
                try {
                    r = this.resultSelector.call(t, u);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                Object object = this.guard;
                synchronized (object) {
                    if (this.done) {
                        return;
                    }
                    this.observer.onNext(r);
                }
            }
        }
    }

    private static final class IterableToObservableFunc<T, R>
    implements Func1<T, Observable<R>> {
        final Func1<? super T, ? extends Iterable<? extends R>> func;

        public IterableToObservableFunc(Func1<? super T, ? extends Iterable<? extends R>> func) {
            this.func = func;
        }

        @Override
        public Observable<R> call(T t1) {
            return Observable.from(this.func.call(t1));
        }
    }
}

