/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.observables.GroupedObservable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func1;

public class OperationGroupByUntil<TSource, TKey, TResult, TDuration>
implements Observable.OnSubscribeFunc<GroupedObservable<TKey, TResult>> {
    final Observable<TSource> source;
    final Func1<? super TSource, ? extends TKey> keySelector;
    final Func1<? super TSource, ? extends TResult> valueSelector;
    final Func1<? super GroupedObservable<TKey, TResult>, ? extends Observable<? extends TDuration>> durationSelector;

    public OperationGroupByUntil(Observable<TSource> source, Func1<? super TSource, ? extends TKey> keySelector, Func1<? super TSource, ? extends TResult> valueSelector, Func1<? super GroupedObservable<TKey, TResult>, ? extends Observable<? extends TDuration>> durationSelector) {
        this.source = source;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.durationSelector = durationSelector;
    }

    @Override
    public Subscription onSubscribe(Observer<? super GroupedObservable<TKey, TResult>> t1) {
        SerialSubscription cancel = new SerialSubscription();
        ResultSink sink = new ResultSink(t1, cancel);
        cancel.setSubscription(sink.run());
        return cancel;
    }

    protected static <T> Observable.OnSubscribeFunc<T> neverSubscribe() {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> t1) {
                return Subscriptions.empty();
            }
        };
    }

    public static class GroupSubject<K, V>
    extends GroupedObservable<K, V>
    implements Observer<V> {
        protected final Subject<V, V> publish;

        public GroupSubject(K key, Subject<V, V> publish) {
            super(key, OperationGroupByUntil.neverSubscribe());
            this.publish = publish;
        }

        @Override
        public Subscription subscribe(Observer<? super V> observer) {
            return this.publish.subscribe(observer);
        }

        @Override
        public void onNext(V args) {
            this.publish.onNext(args);
        }

        @Override
        public void onError(Throwable e) {
            this.publish.onError(e);
        }

        @Override
        public void onCompleted() {
            this.publish.onCompleted();
        }
    }

    class ResultSink
    implements Observer<TSource> {
        protected final Observer<? super GroupedObservable<TKey, TResult>> observer;
        protected final Subscription cancel;
        protected final CompositeSubscription group = new CompositeSubscription(new Subscription[0]);
        protected final Object gate = new Object();
        protected final Map<TKey, GroupSubject<TKey, TResult>> map = new HashMap();

        public ResultSink(Observer<? super GroupedObservable<TKey, TResult>> observer, Subscription cancel) {
            this.observer = observer;
            this.cancel = cancel;
        }

        public Subscription run() {
            SerialSubscription toSource = new SerialSubscription();
            this.group.add(toSource);
            toSource.setSubscription(OperationGroupByUntil.this.source.subscribe(this));
            return this.group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(TSource args) {
            GroupSubject g;
            Object value;
            Object key;
            try {
                key = OperationGroupByUntil.this.keySelector.call(args);
                value = OperationGroupByUntil.this.valueSelector.call(args);
            }
            catch (Throwable t) {
                this.onError(t);
                return;
            }
            boolean newGroup = false;
            Object object = key;
            synchronized (object) {
                g = this.map.get(key);
                if (g == null) {
                    g = this.create(key);
                    this.map.put(key, g);
                    newGroup = true;
                }
            }
            if (newGroup) {
                Observable duration;
                try {
                    duration = OperationGroupByUntil.this.durationSelector.call(g);
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                Object t = this.gate;
                synchronized (t) {
                    this.observer.onNext(g);
                }
                SerialSubscription durationHandle = new SerialSubscription();
                this.group.add(durationHandle);
                DurationObserver durationObserver = new DurationObserver(key, durationHandle);
                durationHandle.setSubscription(duration.subscribe(durationObserver));
            }
            object = this.gate;
            synchronized (object) {
                g.onNext(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.gate;
            synchronized (object) {
                ArrayList gs = new ArrayList(this.map.values());
                this.map.clear();
                for (GroupSubject groupSubject : gs) {
                    groupSubject.onError(e);
                }
                this.observer.onError(e);
            }
            this.cancel.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            Object object = this.gate;
            synchronized (object) {
                ArrayList gs = new ArrayList(this.map.values());
                this.map.clear();
                for (GroupSubject groupSubject : gs) {
                    groupSubject.onCompleted();
                }
                this.observer.onCompleted();
            }
            this.cancel.unsubscribe();
        }

        public GroupSubject<TKey, TResult> create(TKey key) {
            PublishSubject publish = PublishSubject.create();
            return new GroupSubject(key, publish);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire(TKey key, Subscription handle) {
            Object object = this.gate;
            synchronized (object) {
                GroupSubject g = this.map.remove(key);
                if (g != null) {
                    g.onCompleted();
                }
            }
            handle.unsubscribe();
        }

        class DurationObserver
        implements Observer<TDuration> {
            final TKey key;
            final Subscription handle;

            public DurationObserver(TKey key, Subscription handle) {
                this.key = key;
                this.handle = handle;
            }

            @Override
            public void onNext(TDuration args) {
                ResultSink.this.expire(this.key, this.handle);
            }

            @Override
            public void onError(Throwable e) {
                ResultSink.this.onError(e);
            }

            @Override
            public void onCompleted() {
                ResultSink.this.expire(this.key, this.handle);
            }
        }
    }
}

