/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver;
import rx.joins.Pattern1;
import rx.joins.Pattern2;
import rx.joins.Plan0;
import rx.subscriptions.CompositeSubscription;
import rx.util.functions.Action1;
import rx.util.functions.Func1;

public class OperationJoinPatterns {
    public static <T1, T2> Pattern2<T1, T2> and(Observable<T1> left, Observable<T2> right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        return new Pattern2<T1, T2>(left, right);
    }

    public static <T1, R> Plan0<R> then(Observable<T1> source, Func1<T1, R> selector) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (selector == null) {
            throw new NullPointerException("selector");
        }
        return new Pattern1<T1>(source).then(selector);
    }

    public static <R> Observable.OnSubscribeFunc<R> when(Plan0<R> ... plans) {
        if (plans == null) {
            throw new NullPointerException("plans");
        }
        return OperationJoinPatterns.when(Arrays.asList(plans));
    }

    public static <R> Observable.OnSubscribeFunc<R> when(final Iterable<? extends Plan0<R>> plans) {
        if (plans == null) {
            throw new NullPointerException("plans");
        }
        return new Observable.OnSubscribeFunc<R>(){

            @Override
            public Subscription onSubscribe(final Observer<? super R> t1) {
                final HashMap<Object, JoinObserver> externalSubscriptions = new HashMap<Object, JoinObserver>();
                Object gate = new Object();
                final ArrayList<ActivePlan0> activePlans = new ArrayList<ActivePlan0>();
                final Observer out = new Observer<R>(){

                    @Override
                    public void onNext(R args) {
                        t1.onNext(args);
                    }

                    @Override
                    public void onError(Throwable e) {
                        for (JoinObserver po : externalSubscriptions.values()) {
                            po.unsubscribe();
                        }
                        t1.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        t1.onCompleted();
                    }
                };
                try {
                    for (Plan0 plan : plans) {
                        activePlans.add(plan.activate(externalSubscriptions, out, new Action1<ActivePlan0>(){

                            @Override
                            public void call(ActivePlan0 activePlan) {
                                activePlans.remove(activePlan);
                                if (activePlans.isEmpty()) {
                                    out.onCompleted();
                                }
                            }
                        }));
                    }
                }
                catch (Throwable t) {
                    return Observable.error(t).subscribe(t1);
                }
                CompositeSubscription group = new CompositeSubscription(new Subscription[0]);
                for (JoinObserver jo : externalSubscriptions.values()) {
                    jo.subscribe(gate);
                    group.add(jo);
                }
                return group;
            }
        };
    }
}

