/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.util.Exceptions;

public final class OperationLatest {
    private OperationLatest() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Iterable<T> latest(final Observable<? extends T> source) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                LatestObserverIterator lio = new LatestObserverIterator();
                source.materialize().subscribe(lio);
                return lio;
            }
        };
    }

    static final class LatestObserverIterator<T>
    implements Observer<Notification<? extends T>>,
    Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<? extends T>> reference = new AtomicReference();
        Notification<? extends T> iNotif;

        LatestObserverIterator() {
        }

        @Override
        public void onNext(Notification<? extends T> args) {
            boolean wasntAvailable;
            boolean bl = wasntAvailable = this.reference.getAndSet(args) == null;
            if (wasntAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public boolean hasNext() {
            if (this.iNotif != null && this.iNotif.isOnError()) {
                throw Exceptions.propagate(this.iNotif.getThrowable());
            }
            if (!(this.iNotif != null && this.iNotif.isOnCompleted() || this.iNotif != null)) {
                try {
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    this.iNotif = new Notification(ex);
                    throw Exceptions.propagate(ex);
                }
                this.iNotif = this.reference.getAndSet(null);
                if (this.iNotif.isOnError()) {
                    throw Exceptions.propagate(this.iNotif.getThrowable());
                }
            }
            return !this.iNotif.isOnCompleted();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iNotif.isOnNext()) {
                T v = this.iNotif.getValue();
                this.iNotif = null;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

