/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationMap {
    public static <T, R> Observable.OnSubscribeFunc<R> map(Observable<? extends T> sequence, final Func1<? super T, ? extends R> func) {
        return OperationMap.mapWithIndex(sequence, new Func2<T, Integer, R>(){

            @Override
            public R call(T value, Integer unused) {
                return func.call(value);
            }
        });
    }

    public static <T, R> Observable.OnSubscribeFunc<R> mapWithIndex(final Observable<? extends T> sequence, final Func2<? super T, Integer, ? extends R> func) {
        return new Observable.OnSubscribeFunc<R>(){

            @Override
            public Subscription onSubscribe(Observer<? super R> observer) {
                return new MapObservable(sequence, func).onSubscribe(observer);
            }
        };
    }

    private static class MapObservable<T, R>
    implements Observable.OnSubscribeFunc<R> {
        private final Observable<? extends T> sequence;
        private final Func2<? super T, Integer, ? extends R> func;
        private int index;

        public MapObservable(Observable<? extends T> sequence, Func2<? super T, Integer, ? extends R> func) {
            this.sequence = sequence;
            this.func = func;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super R> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.sequence.subscribe(new SafeObserver(subscription, new Observer<T>(){

                @Override
                public void onNext(T value) {
                    observer.onNext(MapObservable.this.func.call(value, MapObservable.this.index));
                    MapObservable.this.index++;
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            })));
        }
    }
}

