/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.LinkedList;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.CompositeSubscription;

public final class OperationMerge {
    public static <T> Observable.OnSubscribeFunc<T> merge(Observable<? extends Observable<? extends T>> o) {
        return OperationMerge.merge(o, Integer.MAX_VALUE);
    }

    public static <T> Observable.OnSubscribeFunc<T> merge(final Observable<? extends Observable<? extends T>> o, final int maxConcurrent) {
        if (maxConcurrent <= 0) {
            throw new IllegalArgumentException("maxConcurrent must be positive");
        }
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new MergeObservable(o, maxConcurrent).onSubscribe(observer);
            }
        };
    }

    private static final class MergeObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;
        private final CompositeSubscription ourSubscription = new CompositeSubscription(new Subscription[0]);
        private volatile boolean parentCompleted = false;
        private final LinkedList<Observable<? extends T>> pendingObservables = new LinkedList();
        private volatile int activeObservableCount = 0;
        private final int maxConcurrent;
        private final Object gate = new Object();

        private MergeObservable(Observable<? extends Observable<? extends T>> sequences, int maxConcurrent) {
            this.sequences = sequences;
            this.maxConcurrent = maxConcurrent;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> actualObserver) {
            SafeObservableSubscription subscription = new SafeObservableSubscription(this.ourSubscription);
            SynchronizedObserver<? super T> synchronizedObserver = new SynchronizedObserver<T>(new SafeObserver<T>(subscription, actualObserver), subscription);
            this.ourSubscription.add(this.sequences.subscribe(new ParentObserver(synchronizedObserver)));
            return subscription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isStopped() {
            Object object = this.gate;
            synchronized (object) {
                return this.parentCompleted && this.activeObservableCount == 0 && this.pendingObservables.size() == 0;
            }
        }

        private class ChildObserver
        implements Observer<T> {
            private final SynchronizedObserver<T> synchronizedObserver;

            public ChildObserver(SynchronizedObserver<T> synchronizedObserver) {
                this.synchronizedObserver = synchronizedObserver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                Observable childObservable = null;
                Object object = MergeObservable.this.gate;
                synchronized (object) {
                    childObservable = (Observable)MergeObservable.this.pendingObservables.poll();
                    if (childObservable == null) {
                        MergeObservable.this.activeObservableCount--;
                    }
                }
                if (childObservable != null) {
                    MergeObservable.this.ourSubscription.add(childObservable.subscribe(this));
                } else if (MergeObservable.this.isStopped()) {
                    this.synchronizedObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.synchronizedObserver.onError(e);
            }

            @Override
            public void onNext(T args) {
                this.synchronizedObserver.onNext(args);
            }
        }

        private class ParentObserver
        implements Observer<Observable<? extends T>> {
            private final SynchronizedObserver<T> synchronizedObserver;

            public ParentObserver(SynchronizedObserver<T> synchronizedObserver) {
                this.synchronizedObserver = synchronizedObserver;
            }

            @Override
            public void onCompleted() {
                MergeObservable.this.parentCompleted = true;
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                if (MergeObservable.this.isStopped()) {
                    this.synchronizedObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.synchronizedObserver.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(Observable<? extends T> childObservable) {
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                if (childObservable == null) {
                    throw new IllegalArgumentException("Observable<T> can not be null.");
                }
                Observable observable = null;
                Object object = MergeObservable.this.gate;
                synchronized (object) {
                    if (MergeObservable.this.activeObservableCount >= MergeObservable.this.maxConcurrent) {
                        MergeObservable.this.pendingObservables.add(childObservable);
                    } else {
                        observable = childObservable;
                        MergeObservable.this.activeObservableCount++;
                    }
                }
                if (observable != null) {
                    MergeObservable.this.ourSubscription.add(observable.subscribe(new ChildObserver(this.synchronizedObserver)));
                }
            }
        }
    }
}

