/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Scheduler;
import rx.observables.GroupedObservable;
import rx.schedulers.Schedulers;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationParallel<T> {
    public static <T, R> Observable<R> parallel(Observable<T> source, Func1<Observable<T>, Observable<R>> f) {
        return OperationParallel.parallel(source, f, Schedulers.threadPoolForComputation());
    }

    public static <T, R> Observable<R> parallel(final Observable<T> source, final Func1<Observable<T>, Observable<R>> f, final Scheduler s) {
        return Observable.defer(new Func0<Observable<R>>(){

            @Override
            public Observable<R> call() {
                final AtomicInteger i = new AtomicInteger(0);
                return source.groupBy(new Func1<T, Integer>(){

                    @Override
                    public Integer call(T t) {
                        return i.incrementAndGet() % s.degreeOfParallelism();
                    }
                }).mergeMap(new Func1<GroupedObservable<Integer, T>, Observable<R>>(){

                    @Override
                    public Observable<R> call(GroupedObservable<Integer, T> group) {
                        return (Observable)f.call(group.observeOn(s));
                    }
                });
            }
        });
    }
}

