/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.util.functions.Func2;

public class OperationRetry {
    private static final int INFINITE_RETRY = -1;

    public static <T> Observable.OnSubscribeFunc<T> retry(Observable<T> observable, int retryCount) {
        return new Retry<T>(observable, retryCount);
    }

    public static <T> Observable.OnSubscribeFunc<T> retry(Observable<T> observable) {
        return new Retry<T>(observable, -1);
    }

    private static class Retry<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<T> source;
        private final int retryCount;
        private final AtomicInteger attempts = new AtomicInteger(0);
        private final CompositeSubscription subscription = new CompositeSubscription(new Subscription[0]);

        public Retry(Observable<T> source, int retryCount) {
            this.source = source;
            this.retryCount = retryCount;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            MultipleAssignmentSubscription rescursiveSubscription = new MultipleAssignmentSubscription();
            this.subscription.add(Schedulers.currentThread().schedule(rescursiveSubscription, this.attemptSubscription(observer)));
            this.subscription.add(rescursiveSubscription);
            return this.subscription;
        }

        private Func2<Scheduler, MultipleAssignmentSubscription, Subscription> attemptSubscription(final Observer<? super T> observer) {
            return new Func2<Scheduler, MultipleAssignmentSubscription, Subscription>(){

                @Override
                public Subscription call(final Scheduler scheduler, final MultipleAssignmentSubscription rescursiveSubscription) {
                    Retry.this.attempts.incrementAndGet();
                    return Retry.this.source.subscribe(new Observer<T>(){

                        @Override
                        public void onCompleted() {
                            observer.onCompleted();
                        }

                        @Override
                        public void onError(Throwable e) {
                            if (!(Retry.this.retryCount != -1 && Retry.this.attempts.get() > Retry.this.retryCount || Retry.this.subscription.isUnsubscribed())) {
                                rescursiveSubscription.setSubscription(scheduler.schedule(rescursiveSubscription, Retry.this.attemptSubscription(observer)));
                            } else {
                                observer.onError(e);
                            }
                        }

                        @Override
                        public void onNext(T v) {
                            observer.onNext(v);
                        }
                    });
                }
            };
        }
    }
}

