/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.OperationInterval;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationSample {
    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit) {
        return new Sample(source, period, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit, Scheduler scheduler) {
        return new Sample(source, period, unit, scheduler);
    }

    public static class SampleWithObservable<T, U>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<T> source;
        final Observable<U> sampler;

        public SampleWithObservable(Observable<T> source, Observable<U> sampler) {
            this.source = source;
            this.sampler = sampler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            return new ResultManager(t1).init();
        }

        class ResultManager
        implements Observer<T> {
            final Observer<? super T> observer;
            final CompositeSubscription cancel;
            T value;
            boolean valueTaken = true;
            boolean done;
            final Object guard;

            public ResultManager(Observer<? super T> observer) {
                this.observer = observer;
                this.cancel = new CompositeSubscription(new Subscription[0]);
                this.guard = new Object();
            }

            public Subscription init() {
                this.cancel.add(SampleWithObservable.this.source.subscribe(this));
                this.cancel.add(SampleWithObservable.this.sampler.subscribe(new Sampler()));
                return this.cancel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                Object object = this.guard;
                synchronized (object) {
                    this.valueTaken = false;
                    this.value = args;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.guard;
                synchronized (object) {
                    if (!this.done) {
                        this.done = true;
                        this.observer.onError(e);
                        this.cancel.unsubscribe();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = this.guard;
                synchronized (object) {
                    if (!this.done) {
                        this.done = true;
                        this.observer.onCompleted();
                        this.cancel.unsubscribe();
                    }
                }
            }

            class Sampler
            implements Observer<U> {
                Sampler() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(U args) {
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        if (!ResultManager.this.valueTaken && !ResultManager.this.done) {
                            ResultManager.this.valueTaken = true;
                            ResultManager.this.observer.onNext(ResultManager.this.value);
                        }
                    }
                }

                @Override
                public void onError(Throwable e) {
                    ResultManager.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    ResultManager.this.onCompleted();
                }
            }
        }
    }

    private static class Sample<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final long period;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicBoolean hasValue = new AtomicBoolean();
        private final AtomicReference<T> latestValue = new AtomicReference();

        private Sample(Observable<? extends T> source, long interval, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.period = interval;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            Observable<Long> clock = Observable.create(OperationInterval.interval(this.period, this.unit, this.scheduler));
            final Subscription clockSubscription = clock.subscribe(new Observer<Long>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onNext(Long tick) {
                    if (Sample.this.hasValue.get()) {
                        observer.onNext(Sample.this.latestValue.get());
                    }
                }
            });
            final Subscription sourceSubscription = this.source.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                    clockSubscription.unsubscribe();
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    clockSubscription.unsubscribe();
                    observer.onError(e);
                }

                @Override
                public void onNext(T value) {
                    Sample.this.latestValue.set(value);
                    Sample.this.hasValue.set(true);
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    clockSubscription.unsubscribe();
                    sourceSubscription.unsubscribe();
                }
            });
        }
    }
}

