/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public class OperationSingle {
    public static <T> Observable.OnSubscribeFunc<T> single(Observable<? extends T> source) {
        return OperationSingle.single(source, false, null);
    }

    public static <T> Observable.OnSubscribeFunc<T> singleOrDefault(Observable<? extends T> source, T defaultValue) {
        return OperationSingle.single(source, true, defaultValue);
    }

    private static <T> Observable.OnSubscribeFunc<T> single(final Observable<? extends T> source, final boolean hasDefaultValue, final T defaultValue) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(final Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(source.subscribe(new Observer<T>(){
                    private T value;
                    private boolean isEmpty = true;
                    private boolean hasTooManyElemenets;

                    @Override
                    public void onCompleted() {
                        if (!this.hasTooManyElemenets) {
                            if (this.isEmpty) {
                                if (hasDefaultValue) {
                                    observer.onNext(defaultValue);
                                    observer.onCompleted();
                                } else {
                                    observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                                }
                            } else {
                                observer.onNext(this.value);
                                observer.onCompleted();
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        observer.onError(e);
                    }

                    @Override
                    public void onNext(T value) {
                        if (this.isEmpty) {
                            this.value = value;
                            this.isEmpty = false;
                        } else {
                            this.hasTooManyElemenets = true;
                            observer.onError(new IllegalArgumentException("Sequence contains too many elements"));
                            subscription.unsubscribe();
                        }
                    }
                }));
                return subscription;
            }
        };
    }
}

