/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.util.functions.Action0;

public final class OperationSkip {
    public static <T> Observable.OnSubscribeFunc<T> skip(final Observable<? extends T> items, final int num) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Skip(items, num).onSubscribe(observer);
            }
        };
    }

    public static final class SkipTimed<T>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;

        public SkipTimed(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            SafeObservableSubscription timer = new SafeObservableSubscription();
            SafeObservableSubscription data = new SafeObservableSubscription();
            CompositeSubscription csub = new CompositeSubscription(timer, data);
            SourceObserver<? super T> so = new SourceObserver<T>(t1, csub);
            data.wrap(this.source.subscribe(so));
            if (!data.isUnsubscribed()) {
                timer.wrap(this.scheduler.schedule(so, this.time, this.unit));
            }
            return csub;
        }

        private static final class SourceObserver<T>
        implements Observer<T>,
        Action0 {
            final AtomicBoolean gate = new AtomicBoolean();
            final Observer<? super T> observer;
            final Subscription cancel;

            public SourceObserver(Observer<? super T> observer, Subscription cancel) {
                this.observer = observer;
                this.cancel = cancel;
            }

            @Override
            public void onNext(T args) {
                if (this.gate.get()) {
                    this.observer.onNext(args);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    this.observer.onError(e);
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    this.observer.onCompleted();
                }
                finally {
                    this.cancel.unsubscribe();
                }
            }

            @Override
            public void call() {
                this.gate.set(true);
            }
        }
    }

    private static class Skip<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int num;
        private final Observable<? extends T> items;

        Skip(Observable<? extends T> items, int num) {
            this.num = num;
            this.items = items;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new ItemObserver(observer));
        }

        private class ItemObserver
        implements Observer<T> {
            private AtomicInteger counter = new AtomicInteger();
            private final Observer<? super T> observer;

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                if (this.counter.incrementAndGet() > Skip.this.num) {
                    this.observer.onNext(args);
                }
            }
        }
    }
}

