/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;

public class OperationSkipUntil<T, U>
implements Observable.OnSubscribeFunc<T> {
    protected final Observable<T> source;
    protected final Observable<U> other;

    public OperationSkipUntil(Observable<T> source, Observable<U> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public Subscription onSubscribe(Observer<? super T> t1) {
        return new ResultManager(t1).init();
    }

    private class ResultManager
    implements Subscription,
    Observer<T> {
        final Observer<? super T> observer;
        final CompositeSubscription cancel;
        final Object guard = new Object();
        final AtomicBoolean running = new AtomicBoolean();

        public ResultManager(Observer<? super T> observer) {
            this.observer = observer;
            this.cancel = new CompositeSubscription(new Subscription[0]);
        }

        public ResultManager init() {
            SerialSubscription toSource = new SerialSubscription();
            SerialSubscription toOther = new SerialSubscription();
            this.cancel.add(toSource);
            this.cancel.add(toOther);
            toSource.setSubscription(OperationSkipUntil.this.source.subscribe(this));
            toOther.setSubscription(OperationSkipUntil.this.other.subscribe(new OtherObserver(toOther)));
            return this;
        }

        @Override
        public void unsubscribe() {
            this.cancel.unsubscribe();
        }

        @Override
        public void onNext(T args) {
            if (this.running.get()) {
                this.observer.onNext(args);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.guard;
            synchronized (object) {
                this.observer.onError(e);
                this.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            Object object = this.guard;
            synchronized (object) {
                this.observer.onCompleted();
                this.unsubscribe();
            }
        }

        private class OtherObserver
        implements Observer<U> {
            final Subscription self;

            public OtherObserver(Subscription self) {
                this.self = self;
            }

            @Override
            public void onNext(U args) {
                ResultManager.this.running.set(true);
                this.self.unsubscribe();
            }

            @Override
            public void onError(Throwable e) {
                ResultManager.this.onError(e);
            }

            @Override
            public void onCompleted() {
                this.self.unsubscribe();
            }
        }
    }
}

