/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationSum {
    public static Observable<Integer> sum(Observable<Integer> source) {
        return source.reduce(0, new Func2<Integer, Integer, Integer>(){

            @Override
            public Integer call(Integer accu, Integer next) {
                return accu + next;
            }
        });
    }

    public static Observable<Long> sumLongs(Observable<Long> source) {
        return source.reduce(0L, new Func2<Long, Long, Long>(){

            @Override
            public Long call(Long accu, Long next) {
                return accu + next;
            }
        });
    }

    public static Observable<Float> sumFloats(Observable<Float> source) {
        return source.reduce(Float.valueOf(0.0f), new Func2<Float, Float, Float>(){

            @Override
            public Float call(Float accu, Float next) {
                return Float.valueOf(accu.floatValue() + next.floatValue());
            }
        });
    }

    public static Observable<Double> sumDoubles(Observable<Double> source) {
        return source.reduce(0.0, new Func2<Double, Double, Double>(){

            @Override
            public Double call(Double accu, Double next) {
                return accu + next;
            }
        });
    }

    public static final class SumDoubleExtractor<T>
    implements Observable.OnSubscribeFunc<Double> {
        final Observable<? extends T> source;
        final Func1<? super T, Double> valueExtractor;

        public SumDoubleExtractor(Observable<? extends T> source, Func1<? super T, Double> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Double> t1) {
            return this.source.subscribe(new SumObserver(t1));
        }

        private final class SumObserver
        implements Observer<T> {
            final Observer<? super Double> observer;
            double sum;
            boolean hasValue;

            public SumObserver(Observer<? super Double> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += SumDoubleExtractor.this.valueExtractor.call(args).doubleValue();
                this.hasValue = true;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.hasValue) {
                    try {
                        this.observer.onNext((Double)this.sum);
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class SumFloatExtractor<T>
    implements Observable.OnSubscribeFunc<Float> {
        final Observable<? extends T> source;
        final Func1<? super T, Float> valueExtractor;

        public SumFloatExtractor(Observable<? extends T> source, Func1<? super T, Float> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Float> t1) {
            return this.source.subscribe(new SumObserver(t1));
        }

        private final class SumObserver
        implements Observer<T> {
            final Observer<? super Float> observer;
            float sum;
            boolean hasValue;

            public SumObserver(Observer<? super Float> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += SumFloatExtractor.this.valueExtractor.call(args).floatValue();
                this.hasValue = true;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.hasValue) {
                    try {
                        this.observer.onNext(Float.valueOf(this.sum));
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class SumLongExtractor<T>
    implements Observable.OnSubscribeFunc<Long> {
        final Observable<? extends T> source;
        final Func1<? super T, Long> valueExtractor;

        public SumLongExtractor(Observable<? extends T> source, Func1<? super T, Long> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Long> t1) {
            return this.source.subscribe(new SumObserver(t1));
        }

        private final class SumObserver
        implements Observer<T> {
            final Observer<? super Long> observer;
            long sum;
            boolean hasValue;

            public SumObserver(Observer<? super Long> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += SumLongExtractor.this.valueExtractor.call(args).longValue();
                this.hasValue = true;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.hasValue) {
                    try {
                        this.observer.onNext((Long)this.sum);
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class SumIntegerExtractor<T>
    implements Observable.OnSubscribeFunc<Integer> {
        final Observable<? extends T> source;
        final Func1<? super T, Integer> valueExtractor;

        public SumIntegerExtractor(Observable<? extends T> source, Func1<? super T, Integer> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Integer> t1) {
            return this.source.subscribe(new SumObserver(t1));
        }

        private final class SumObserver
        implements Observer<T> {
            final Observer<? super Integer> observer;
            int sum;
            boolean hasValue;

            public SumObserver(Observer<? super Integer> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += SumIntegerExtractor.this.valueExtractor.call(args).intValue();
                this.hasValue = true;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.hasValue) {
                    try {
                        this.observer.onNext((Integer)this.sum);
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }
}

