/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;

public final class OperationSwitch {
    public static <T> Observable.OnSubscribeFunc<T> switchDo(final Observable<? extends Observable<? extends T>> sequences) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Switch(sequences).onSubscribe(observer);
            }
        };
    }

    private static class SwitchObserver<T>
    implements Observer<Observable<? extends T>> {
        private final Object gate;
        private final Observer<? super T> observer;
        private final SafeObservableSubscription parent;
        private final SerialSubscription child;
        private long latest;
        private boolean stopped;
        private boolean hasLatest;

        public SwitchObserver(Observer<? super T> observer, SafeObservableSubscription parent, SerialSubscription child) {
            this.observer = observer;
            this.parent = parent;
            this.child = child;
            this.gate = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> args) {
            long id;
            Object object = this.gate;
            synchronized (object) {
                id = ++this.latest;
                this.hasLatest = true;
            }
            final SafeObservableSubscription sub = new SafeObservableSubscription();
            sub.wrap(args.subscribe(new Observer<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T args) {
                    Object object = SwitchObserver.this.gate;
                    synchronized (object) {
                        if (SwitchObserver.this.latest == id) {
                            SwitchObserver.this.observer.onNext(args);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable e) {
                    sub.unsubscribe();
                    SafeObservableSubscription s = null;
                    Object object = SwitchObserver.this.gate;
                    synchronized (object) {
                        if (SwitchObserver.this.latest == id) {
                            SwitchObserver.this.observer.onError(e);
                            s = SwitchObserver.this.parent;
                        }
                    }
                    if (s != null) {
                        s.unsubscribe();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    sub.unsubscribe();
                    SafeObservableSubscription s = null;
                    Object object = SwitchObserver.this.gate;
                    synchronized (object) {
                        if (SwitchObserver.this.latest == id) {
                            SwitchObserver.this.hasLatest = false;
                            if (SwitchObserver.this.stopped) {
                                SwitchObserver.this.observer.onCompleted();
                                s = SwitchObserver.this.parent;
                            }
                        }
                    }
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            }));
            this.child.setSubscription(sub);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.gate;
            synchronized (object) {
                this.observer.onError(e);
            }
            this.parent.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            SafeObservableSubscription s = null;
            Object object = this.gate;
            synchronized (object) {
                this.stopped = true;
                if (!this.hasLatest) {
                    this.observer.onCompleted();
                    s = this.parent;
                }
            }
            if (s != null) {
                s.unsubscribe();
            }
        }
    }

    private static class Switch<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;

        public Switch(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            SafeObservableSubscription parent = new SafeObservableSubscription();
            SerialSubscription child = new SerialSubscription();
            parent.wrap(this.sequences.subscribe(new SwitchObserver<T>(observer, parent, child)));
            return new CompositeSubscription(parent, child);
        }
    }
}

