/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationTimeout {
    public static <T> Observable.OnSubscribeFunc<T> timeout(Observable<? extends T> source, long timeout, TimeUnit timeUnit) {
        return new Timeout(source, timeout, timeUnit, null, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> timeout(Observable<? extends T> sequence, long timeout, TimeUnit timeUnit, Observable<? extends T> other) {
        return new Timeout(sequence, timeout, timeUnit, other, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> timeout(Observable<? extends T> source, long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return new Timeout(source, timeout, timeUnit, null, scheduler);
    }

    public static <T> Observable.OnSubscribeFunc<T> timeout(Observable<? extends T> sequence, long timeout, TimeUnit timeUnit, Observable<? extends T> other, Scheduler scheduler) {
        return new Timeout(sequence, timeout, timeUnit, other, scheduler);
    }

    public static <T, U, V> Observable.OnSubscribeFunc<T> timeoutSelector(Observable<? extends T> source, Func0<? extends Observable<U>> firstValueTimeout, Func1<? super T, ? extends Observable<V>> valueTimeout, Observable<? extends T> other) {
        return new TimeoutSelector(source, firstValueTimeout, valueTimeout, other);
    }

    private static final class TimeoutSelector<T, U, V>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final Func0<? extends Observable<U>> firstValueTimeout;
        final Func1<? super T, ? extends Observable<V>> valueTimeout;
        final Observable<? extends T> other;

        public TimeoutSelector(Observable<? extends T> source, Func0<? extends Observable<U>> firstValueTimeout, Func1<? super T, ? extends Observable<V>> valueTimeout, Observable<? extends T> other) {
            this.source = source;
            this.firstValueTimeout = firstValueTimeout;
            this.valueTimeout = valueTimeout;
            this.other = other;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            CompositeSubscription csub = new CompositeSubscription(new Subscription[0]);
            SourceObserver so = new SourceObserver(t1, this.valueTimeout, this.other, csub);
            if (this.firstValueTimeout != null) {
                Observable<U> o;
                try {
                    o = this.firstValueTimeout.call();
                }
                catch (Throwable t) {
                    t1.onError(t);
                    return Subscriptions.empty();
                }
                csub.add(o.subscribe(new TimeoutObserver(so)));
            }
            csub.add(this.source.subscribe(so));
            return csub;
        }

        private static final class TimeoutObserver<V>
        implements Observer<V> {
            final TimeoutCallback parent;

            public TimeoutObserver(TimeoutCallback parent) {
                this.parent = parent;
            }

            @Override
            public void onNext(V args) {
                this.parent.timeout();
            }

            @Override
            public void onError(Throwable e) {
                this.parent.onError(e);
            }

            @Override
            public void onCompleted() {
                this.parent.timeout();
            }
        }

        private static interface TimeoutCallback {
            public void timeout();

            public void onError(Throwable var1);
        }

        private static final class SourceObserver<T, V>
        implements Observer<T>,
        TimeoutCallback {
            final Observer<? super T> observer;
            final Func1<? super T, ? extends Observable<V>> valueTimeout;
            final Observable<? extends T> other;
            final CompositeSubscription cancel;
            final Object guard;
            boolean done;
            final SerialSubscription tsub;
            final TimeoutObserver<V> to;

            public SourceObserver(Observer<? super T> observer, Func1<? super T, ? extends Observable<V>> valueTimeout, Observable<? extends T> other, CompositeSubscription cancel) {
                this.observer = observer;
                this.valueTimeout = valueTimeout;
                this.other = other;
                this.cancel = cancel;
                this.guard = new Object();
                this.tsub = new SerialSubscription();
                this.cancel.add(this.tsub);
                this.to = new TimeoutObserver(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                Observable<V> o;
                this.tsub.set(Subscriptions.empty());
                Object object = this.guard;
                synchronized (object) {
                    if (this.done) {
                        return;
                    }
                    this.observer.onNext(args);
                }
                try {
                    o = this.valueTimeout.call(args);
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                SerialSubscription osub = new SerialSubscription();
                this.tsub.set(osub);
                osub.set(o.subscribe(this.to));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.guard;
                synchronized (object) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    this.observer.onError(e);
                }
                this.cancel.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = this.guard;
                synchronized (object) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    this.observer.onCompleted();
                }
                this.cancel.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timeout() {
                if (this.other != null) {
                    Object object = this.guard;
                    synchronized (object) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                    }
                    this.cancel.clear();
                    this.cancel.add(this.other.subscribe(this.observer));
                } else {
                    this.onCompleted();
                }
            }
        }
    }

    private static class Timeout<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final Scheduler scheduler;
        private final Observable<? extends T> other;

        private Timeout(Observable<? extends T> source, long timeout, TimeUnit timeUnit, Observable<? extends T> other, Scheduler scheduler) {
            this.source = source;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.other = other;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final AtomicBoolean terminated = new AtomicBoolean(false);
            final AtomicLong actual = new AtomicLong(0L);
            final SerialSubscription serial = new SerialSubscription();
            final Object gate = new Object();
            CompositeSubscription composite = new CompositeSubscription(new Subscription[0]);
            final Func0<Subscription> schedule = new Func0<Subscription>(){

                @Override
                public Subscription call() {
                    final long expected = actual.get();
                    return Timeout.this.scheduler.schedule(new Action0(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void call() {
                            boolean timeoutWins = false;
                            Object object = gate;
                            synchronized (object) {
                                if (expected == actual.get() && !terminated.getAndSet(true)) {
                                    timeoutWins = true;
                                }
                            }
                            if (timeoutWins) {
                                if (Timeout.this.other == null) {
                                    observer.onError(new TimeoutException());
                                } else {
                                    serial.setSubscription(Timeout.this.other.subscribe(observer));
                                }
                            }
                        }
                    }, Timeout.this.timeout, Timeout.this.timeUnit);
                }
            };
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            composite.add(subscription.wrap(this.source.subscribe(new Observer<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T value) {
                    boolean onNextWins = false;
                    Object object = gate;
                    synchronized (object) {
                        if (!terminated.get()) {
                            actual.incrementAndGet();
                            onNextWins = true;
                        }
                    }
                    if (onNextWins) {
                        serial.setSubscription((Subscription)schedule.call());
                        observer.onNext(value);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable error) {
                    boolean onErrorWins = false;
                    Object object = gate;
                    synchronized (object) {
                        if (!terminated.getAndSet(true)) {
                            onErrorWins = true;
                        }
                    }
                    if (onErrorWins) {
                        serial.unsubscribe();
                        observer.onError(error);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    boolean onCompletedWins = false;
                    Object object = gate;
                    synchronized (object) {
                        if (!terminated.getAndSet(true)) {
                            onCompletedWins = true;
                        }
                    }
                    if (onCompletedWins) {
                        serial.unsubscribe();
                        observer.onCompleted();
                    }
                }
            })));
            composite.add(serial);
            serial.setSubscription((Subscription)schedule.call());
            return composite;
        }
    }
}

