/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Scheduler;
import rx.operators.OperationMap;
import rx.util.Timestamped;
import rx.util.functions.Func1;

public final class OperationTimestamp {
    public static <T> Observable.OnSubscribeFunc<Timestamped<T>> timestamp(Observable<? extends T> sequence) {
        return OperationMap.map(sequence, new Func1<T, Timestamped<T>>(){

            @Override
            public Timestamped<T> call(T value) {
                return new Timestamped(System.currentTimeMillis(), value);
            }
        });
    }

    public static <T> Observable.OnSubscribeFunc<Timestamped<T>> timestamp(Observable<? extends T> source, final Scheduler scheduler) {
        return OperationMap.map(source, new Func1<T, Timestamped<T>>(){

            @Override
            public Timestamped<T> call(T value) {
                return new Timestamped(scheduler.now(), value);
            }
        });
    }
}

