/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.util.Exceptions;

public class OperationToIterator {
    public static <T> Iterator<T> toIterator(Observable<? extends T> source) {
        final LinkedBlockingQueue notifications = new LinkedBlockingQueue();
        source.materialize().subscribe(new Observer<Notification<? extends T>>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
            }

            @Override
            public void onNext(Notification<? extends T> args) {
                notifications.offer(args);
            }
        });
        return new Iterator<T>(){
            private Notification<? extends T> buf;

            @Override
            public boolean hasNext() {
                if (this.buf == null) {
                    this.buf = this.take();
                }
                if (this.buf.isOnError()) {
                    throw Exceptions.propagate(this.buf.getThrowable());
                }
                return !this.buf.isOnCompleted();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.buf.getValue();
                    this.buf = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            private Notification<? extends T> take() {
                try {
                    return (Notification)notifications.take();
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator");
            }
        };
    }
}

